// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    internal static partial class DocumentFieldTypeExtensions
    {
        public static string ToSerialString(this DocumentFieldType value) => value switch
        {
            DocumentFieldType.String => "string",
            DocumentFieldType.Date => "date",
            DocumentFieldType.Time => "time",
            DocumentFieldType.PhoneNumber => "phoneNumber",
            DocumentFieldType.Double => "number",
            DocumentFieldType.Int64 => "integer",
            DocumentFieldType.SelectionMark => "selectionMark",
            DocumentFieldType.CountryRegion => "countryRegion",
            DocumentFieldType.Signature => "signature",
            DocumentFieldType.List => "array",
            DocumentFieldType.Dictionary => "object",
            DocumentFieldType.Currency => "currency",
            DocumentFieldType.Address => "address",
            DocumentFieldType.Boolean => "boolean",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DocumentFieldType value.")
        };

        public static DocumentFieldType ToDocumentFieldType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "string")) return DocumentFieldType.String;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "date")) return DocumentFieldType.Date;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "time")) return DocumentFieldType.Time;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "phoneNumber")) return DocumentFieldType.PhoneNumber;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "number")) return DocumentFieldType.Double;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "integer")) return DocumentFieldType.Int64;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "selectionMark")) return DocumentFieldType.SelectionMark;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "countryRegion")) return DocumentFieldType.CountryRegion;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "signature")) return DocumentFieldType.Signature;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "array")) return DocumentFieldType.List;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "object")) return DocumentFieldType.Dictionary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "currency")) return DocumentFieldType.Currency;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "address")) return DocumentFieldType.Address;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "boolean")) return DocumentFieldType.Boolean;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DocumentFieldType value.");
        }
    }
}
