// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Error response object. </summary>
    internal partial class DocumentErrorResponse
    {
        /// <summary> Initializes a new instance of <see cref="DocumentErrorResponse"/>. </summary>
        /// <param name="error"> Error info. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="error"/> is null. </exception>
        internal DocumentErrorResponse(Error error)
        {
            Argument.AssertNotNull(error, nameof(error));

            Error = error;
        }

        /// <summary> Error info. </summary>
        public Error Error { get; }
    }
}
