// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Document classifier info. </summary>
    public partial class DocumentClassifierDetails
    {
        /// <summary> Initializes a new instance of <see cref="DocumentClassifierDetails"/>. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="createdOn"> Date and time (UTC) when the document classifier was created. </param>
        /// <param name="serviceVersion"> API version used to create this document classifier. </param>
        /// <param name="documentTypes"> List of document types to classify against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/>, <paramref name="serviceVersion"/> or <paramref name="documentTypes"/> is null. </exception>
        internal DocumentClassifierDetails(string classifierId, DateTimeOffset createdOn, string serviceVersion, IReadOnlyDictionary<string, ClassifierDocumentTypeDetails> documentTypes)
        {
            Argument.AssertNotNull(classifierId, nameof(classifierId));
            Argument.AssertNotNull(serviceVersion, nameof(serviceVersion));
            Argument.AssertNotNull(documentTypes, nameof(documentTypes));

            ClassifierId = classifierId;
            CreatedOn = createdOn;
            ServiceVersion = serviceVersion;
            DocumentTypes = documentTypes;
        }

        /// <summary> Initializes a new instance of <see cref="DocumentClassifierDetails"/>. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="description"> Document classifier description. </param>
        /// <param name="createdOn"> Date and time (UTC) when the document classifier was created. </param>
        /// <param name="expiresOn"> Date and time (UTC) when the document classifier will expire. </param>
        /// <param name="serviceVersion"> API version used to create this document classifier. </param>
        /// <param name="documentTypes"> List of document types to classify against. </param>
        internal DocumentClassifierDetails(string classifierId, string description, DateTimeOffset createdOn, DateTimeOffset? expiresOn, string serviceVersion, IReadOnlyDictionary<string, ClassifierDocumentTypeDetails> documentTypes)
        {
            ClassifierId = classifierId;
            Description = description;
            CreatedOn = createdOn;
            ExpiresOn = expiresOn;
            ServiceVersion = serviceVersion;
            DocumentTypes = documentTypes;
        }

        /// <summary> Unique document classifier name. </summary>
        public string ClassifierId { get; }
        /// <summary> Document classifier description. </summary>
        public string Description { get; }
    }
}
