// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.Training
{
    internal static partial class CustomFormModelStatusExtensions
    {
        public static string ToSerialString(this CustomFormModelStatus value) => value switch
        {
            CustomFormModelStatus.Creating => "creating",
            CustomFormModelStatus.Ready => "ready",
            CustomFormModelStatus.Invalid => "invalid",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CustomFormModelStatus value.")
        };

        public static CustomFormModelStatus ToCustomFormModelStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "creating")) return CustomFormModelStatus.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ready")) return CustomFormModelStatus.Ready;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "invalid")) return CustomFormModelStatus.Invalid;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CustomFormModelStatus value.");
        }
    }
}
