// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.AI.FormRecognizer.Training
{
    public partial class CustomFormModelProperties
    {
        internal static CustomFormModelProperties DeserializeCustomFormModelProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool isComposed = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isComposed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isComposed = property.Value.GetBoolean();
                    continue;
                }
            }
            return new CustomFormModelProperties(isComposed);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CustomFormModelProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCustomFormModelProperties(document.RootElement);
        }
    }
}
