// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.FormRecognizer.Models
{
    /// <summary> Custom model copy result. </summary>
    internal partial class CopyResult
    {
        /// <summary> Initializes a new instance of <see cref="CopyResult"/>. </summary>
        /// <param name="modelId"> Identifier of the target model. </param>
        internal CopyResult(Guid modelId)
        {
            ModelId = modelId;
            Errors = new ChangeTrackingList<FormRecognizerError>();
        }

        /// <summary> Initializes a new instance of <see cref="CopyResult"/>. </summary>
        /// <param name="modelId"> Identifier of the target model. </param>
        /// <param name="errors"> Errors returned during the copy operation. </param>
        internal CopyResult(Guid modelId, IReadOnlyList<FormRecognizerError> errors)
        {
            ModelId = modelId;
            Errors = errors;
        }

        /// <summary> Identifier of the target model. </summary>
        public Guid ModelId { get; }
        /// <summary> Errors returned during the copy operation. </summary>
        public IReadOnlyList<FormRecognizerError> Errors { get; }
    }
}
