// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> A component of a composed document model. </summary>
    internal partial class ComponentDocumentModelDetails
    {
        /// <summary> Initializes a new instance of <see cref="ComponentDocumentModelDetails"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public ComponentDocumentModelDetails(string modelId)
        {
            Argument.AssertNotNull(modelId, nameof(modelId));

            ModelId = modelId;
        }

        /// <summary> Unique document model name. </summary>
        public string ModelId { get; }
    }
}
