// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    internal partial class ClassifyDocumentRequest : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(UrlSource))
            {
                writer.WritePropertyName("urlSource"u8);
                writer.WriteStringValue(UrlSource.AbsoluteUri);
            }
            if (Optional.IsDefined(Base64Source))
            {
                writer.WritePropertyName("base64Source"u8);
                writer.WriteBase64StringValue(Base64Source, "D");
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
