// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    public partial struct BoundingRegion
    {
        internal static BoundingRegion DeserializeBoundingRegion(JsonElement element)
        {
            int pageNumber = default;
            IReadOnlyList<float> polygon = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("pageNumber"u8))
                {
                    pageNumber = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("polygon"u8))
                {
                    List<float> array = new List<float>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetSingle());
                    }
                    polygon = array;
                    continue;
                }
            }
            return new BoundingRegion(pageNumber, polygon);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BoundingRegion FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBoundingRegion(document.RootElement);
        }
    }
}
