// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    internal static partial class AnalyzeResultOperationStatusExtensions
    {
        public static string ToSerialString(this AnalyzeResultOperationStatus value) => value switch
        {
            AnalyzeResultOperationStatus.NotStarted => "notStarted",
            AnalyzeResultOperationStatus.Running => "running",
            AnalyzeResultOperationStatus.Failed => "failed",
            AnalyzeResultOperationStatus.Succeeded => "succeeded",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AnalyzeResultOperationStatus value.")
        };

        public static AnalyzeResultOperationStatus ToAnalyzeResultOperationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "notStarted")) return AnalyzeResultOperationStatus.NotStarted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "running")) return AnalyzeResultOperationStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "failed")) return AnalyzeResultOperationStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "succeeded")) return AnalyzeResultOperationStatus.Succeeded;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AnalyzeResultOperationStatus value.");
        }
    }
}
