// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Status and result of the analyze operation. </summary>
    internal partial class AnalyzeResultOperation
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeResultOperation"/>. </summary>
        /// <param name="status"> Operation status. </param>
        /// <param name="createdDateTime"> Date and time (UTC) when the analyze operation was submitted. </param>
        /// <param name="lastUpdatedDateTime"> Date and time (UTC) when the status was last updated. </param>
        internal AnalyzeResultOperation(AnalyzeResultOperationStatus status, DateTimeOffset createdDateTime, DateTimeOffset lastUpdatedDateTime)
        {
            Status = status;
            CreatedDateTime = createdDateTime;
            LastUpdatedDateTime = lastUpdatedDateTime;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeResultOperation"/>. </summary>
        /// <param name="status"> Operation status. </param>
        /// <param name="createdDateTime"> Date and time (UTC) when the analyze operation was submitted. </param>
        /// <param name="lastUpdatedDateTime"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="error"> Encountered error during document analysis. </param>
        /// <param name="analyzeResult"> Document analysis result. </param>
        internal AnalyzeResultOperation(AnalyzeResultOperationStatus status, DateTimeOffset createdDateTime, DateTimeOffset lastUpdatedDateTime, JsonElement error, AnalyzeResult analyzeResult)
        {
            Status = status;
            CreatedDateTime = createdDateTime;
            LastUpdatedDateTime = lastUpdatedDateTime;
            _error = error;
            AnalyzeResult = analyzeResult;
        }

        /// <summary> Operation status. </summary>
        public AnalyzeResultOperationStatus Status { get; }
        /// <summary> Date and time (UTC) when the analyze operation was submitted. </summary>
        public DateTimeOffset CreatedDateTime { get; }
        /// <summary> Date and time (UTC) when the status was last updated. </summary>
        public DateTimeOffset LastUpdatedDateTime { get; }
        /// <summary> Document analysis result. </summary>
        public AnalyzeResult AnalyzeResult { get; }
    }
}
