// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Document analysis result. </summary>
    public partial class AnalyzeResult
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeResult"/>. </summary>
        /// <param name="serviceVersion"> API version used to produce this result. </param>
        /// <param name="modelId"> Document model ID used to produce this result. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="content"> Concatenate string representation of all textual and visual elements in reading order. </param>
        /// <param name="pages"> Analyzed pages. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceVersion"/>, <paramref name="modelId"/>, <paramref name="content"/> or <paramref name="pages"/> is null. </exception>
        internal AnalyzeResult(string serviceVersion, string modelId, StringIndexType stringIndexType, string content, IEnumerable<DocumentPage> pages)
        {
            Argument.AssertNotNull(serviceVersion, nameof(serviceVersion));
            Argument.AssertNotNull(modelId, nameof(modelId));
            Argument.AssertNotNull(content, nameof(content));
            Argument.AssertNotNull(pages, nameof(pages));

            ServiceVersion = serviceVersion;
            ModelId = modelId;
            StringIndexType = stringIndexType;
            Content = content;
            Pages = pages.ToList();
            Paragraphs = new ChangeTrackingList<DocumentParagraph>();
            Tables = new ChangeTrackingList<DocumentTable>();
            KeyValuePairs = new ChangeTrackingList<DocumentKeyValuePair>();
            Styles = new ChangeTrackingList<DocumentStyle>();
            Languages = new ChangeTrackingList<DocumentLanguage>();
            Documents = new ChangeTrackingList<AnalyzedDocument>();
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeResult"/>. </summary>
        /// <param name="serviceVersion"> API version used to produce this result. </param>
        /// <param name="modelId"> Document model ID used to produce this result. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="content"> Concatenate string representation of all textual and visual elements in reading order. </param>
        /// <param name="pages"> Analyzed pages. </param>
        /// <param name="paragraphs"> Extracted paragraphs. </param>
        /// <param name="tables"> Extracted tables. </param>
        /// <param name="keyValuePairs"> Extracted key-value pairs. </param>
        /// <param name="styles"> Extracted font styles. </param>
        /// <param name="languages"> Detected languages. </param>
        /// <param name="documents"> Extracted documents. </param>
        internal AnalyzeResult(string serviceVersion, string modelId, StringIndexType stringIndexType, string content, IReadOnlyList<DocumentPage> pages, IReadOnlyList<DocumentParagraph> paragraphs, IReadOnlyList<DocumentTable> tables, IReadOnlyList<DocumentKeyValuePair> keyValuePairs, IReadOnlyList<DocumentStyle> styles, IReadOnlyList<DocumentLanguage> languages, IReadOnlyList<AnalyzedDocument> documents)
        {
            ServiceVersion = serviceVersion;
            ModelId = modelId;
            StringIndexType = stringIndexType;
            Content = content;
            Pages = pages;
            Paragraphs = paragraphs;
            Tables = tables;
            KeyValuePairs = keyValuePairs;
            Styles = styles;
            Languages = languages;
            Documents = documents;
        }
        /// <summary> Document model ID used to produce this result. </summary>
        public string ModelId { get; }
        /// <summary> Concatenate string representation of all textual and visual elements in reading order. </summary>
        public string Content { get; }
        /// <summary> Analyzed pages. </summary>
        public IReadOnlyList<DocumentPage> Pages { get; }
        /// <summary> Extracted paragraphs. </summary>
        public IReadOnlyList<DocumentParagraph> Paragraphs { get; }
        /// <summary> Extracted tables. </summary>
        public IReadOnlyList<DocumentTable> Tables { get; }
        /// <summary> Extracted key-value pairs. </summary>
        public IReadOnlyList<DocumentKeyValuePair> KeyValuePairs { get; }
        /// <summary> Extracted font styles. </summary>
        public IReadOnlyList<DocumentStyle> Styles { get; }
        /// <summary> Detected languages. </summary>
        public IReadOnlyList<DocumentLanguage> Languages { get; }
        /// <summary> Extracted documents. </summary>
        public IReadOnlyList<AnalyzedDocument> Documents { get; }
    }
}
