// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    public partial class AnalyzeResult
    {
        internal static AnalyzeResult DeserializeAnalyzeResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string apiVersion = default;
            string modelId = default;
            StringIndexType stringIndexType = default;
            string content = default;
            IReadOnlyList<DocumentPage> pages = default;
            IReadOnlyList<DocumentParagraph> paragraphs = default;
            IReadOnlyList<DocumentTable> tables = default;
            IReadOnlyList<DocumentKeyValuePair> keyValuePairs = default;
            IReadOnlyList<DocumentStyle> styles = default;
            IReadOnlyList<DocumentLanguage> languages = default;
            IReadOnlyList<AnalyzedDocument> documents = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("apiVersion"u8))
                {
                    apiVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modelId"u8))
                {
                    modelId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stringIndexType"u8))
                {
                    stringIndexType = new StringIndexType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("content"u8))
                {
                    content = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("pages"u8))
                {
                    List<DocumentPage> array = new List<DocumentPage>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentPage.DeserializeDocumentPage(item));
                    }
                    pages = array;
                    continue;
                }
                if (property.NameEquals("paragraphs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DocumentParagraph> array = new List<DocumentParagraph>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentParagraph.DeserializeDocumentParagraph(item));
                    }
                    paragraphs = array;
                    continue;
                }
                if (property.NameEquals("tables"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DocumentTable> array = new List<DocumentTable>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentTable.DeserializeDocumentTable(item));
                    }
                    tables = array;
                    continue;
                }
                if (property.NameEquals("keyValuePairs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DocumentKeyValuePair> array = new List<DocumentKeyValuePair>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentKeyValuePair.DeserializeDocumentKeyValuePair(item));
                    }
                    keyValuePairs = array;
                    continue;
                }
                if (property.NameEquals("styles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DocumentStyle> array = new List<DocumentStyle>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentStyle.DeserializeDocumentStyle(item));
                    }
                    styles = array;
                    continue;
                }
                if (property.NameEquals("languages"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DocumentLanguage> array = new List<DocumentLanguage>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentLanguage.DeserializeDocumentLanguage(item));
                    }
                    languages = array;
                    continue;
                }
                if (property.NameEquals("documents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AnalyzedDocument> array = new List<AnalyzedDocument>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AnalyzedDocument.DeserializeAnalyzedDocument(item));
                    }
                    documents = array;
                    continue;
                }
            }
            return new AnalyzeResult(
                apiVersion,
                modelId,
                stringIndexType,
                content,
                pages,
                paragraphs ?? new ChangeTrackingList<DocumentParagraph>(),
                tables ?? new ChangeTrackingList<DocumentTable>(),
                keyValuePairs ?? new ChangeTrackingList<DocumentKeyValuePair>(),
                styles ?? new ChangeTrackingList<DocumentStyle>(),
                languages ?? new ChangeTrackingList<DocumentLanguage>(),
                documents ?? new ChangeTrackingList<AnalyzedDocument>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnalyzeResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnalyzeResult(document.RootElement);
        }
    }
}
