// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    public partial class AddressValue
    {
        internal static AddressValue DeserializeAddressValue(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string houseNumber = default;
            string poBox = default;
            string road = default;
            string city = default;
            string state = default;
            string postalCode = default;
            string countryRegion = default;
            string streetAddress = default;
            string unit = default;
            string cityDistrict = default;
            string stateDistrict = default;
            string suburb = default;
            string house = default;
            string level = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("houseNumber"u8))
                {
                    houseNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("poBox"u8))
                {
                    poBox = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("road"u8))
                {
                    road = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("city"u8))
                {
                    city = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    state = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("postalCode"u8))
                {
                    postalCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("countryRegion"u8))
                {
                    countryRegion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("streetAddress"u8))
                {
                    streetAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("unit"u8))
                {
                    unit = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cityDistrict"u8))
                {
                    cityDistrict = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stateDistrict"u8))
                {
                    stateDistrict = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("suburb"u8))
                {
                    suburb = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("house"u8))
                {
                    house = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("level"u8))
                {
                    level = property.Value.GetString();
                    continue;
                }
            }
            return new AddressValue(
                houseNumber,
                poBox,
                road,
                city,
                state,
                postalCode,
                countryRegion,
                streetAddress,
                unit,
                cityDistrict,
                stateDistrict,
                suburb,
                house,
                level);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AddressValue FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAddressValue(document.RootElement);
        }
    }
}
