// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.IO;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.AI.FormRecognizer.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.FormRecognizer
{
    internal partial class FormRecognizerRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly string _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of FormRecognizerRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoints (protocol and hostname, for example: https://westus2.api.cognitive.microsoft.com). </param>
        /// <param name="apiVersion"> Form Recognizer API version (for example: v2.0). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        public FormRecognizerRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string endpoint, string apiVersion)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateTrainCustomModelAsyncRequest(TrainRequest trainRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(trainRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Train Custom Model. </summary>
        /// <param name="trainRequest"> Training request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="trainRequest"/> is null. </exception>
        /// <remarks> Create and train a custom model. The request must include a source parameter that is either an externally accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}' configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be trained is expected to be under the source folder or sub folders under it. Models are trained using documents that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Other type of content is ignored. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerTrainCustomModelAsyncHeaders>> TrainCustomModelAsyncAsync(TrainRequest trainRequest, CancellationToken cancellationToken = default)
        {
            if (trainRequest == null)
            {
                throw new ArgumentNullException(nameof(trainRequest));
            }

            using var message = CreateTrainCustomModelAsyncRequest(trainRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerTrainCustomModelAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Train Custom Model. </summary>
        /// <param name="trainRequest"> Training request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="trainRequest"/> is null. </exception>
        /// <remarks> Create and train a custom model. The request must include a source parameter that is either an externally accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}' configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be trained is expected to be under the source folder or sub folders under it. Models are trained using documents that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Other type of content is ignored. </remarks>
        public ResponseWithHeaders<FormRecognizerTrainCustomModelAsyncHeaders> TrainCustomModelAsync(TrainRequest trainRequest, CancellationToken cancellationToken = default)
        {
            if (trainRequest == null)
            {
                throw new ArgumentNullException(nameof(trainRequest));
            }

            using var message = CreateTrainCustomModelAsyncRequest(trainRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerTrainCustomModelAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetCustomModelRequest(Guid modelId, bool? includeKeys)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            if (includeKeys != null)
            {
                uri.AppendQuery("includeKeys", includeKeys.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Custom Model. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="includeKeys"> Include list of extracted keys in model information. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Get detailed information about a custom model. </remarks>
        public async Task<Response<Model>> GetCustomModelAsync(Guid modelId, bool? includeKeys = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCustomModelRequest(modelId, includeKeys);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Model value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = Model.DeserializeModel(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Custom Model. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="includeKeys"> Include list of extracted keys in model information. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Get detailed information about a custom model. </remarks>
        public Response<Model> GetCustomModel(Guid modelId, bool? includeKeys = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCustomModelRequest(modelId, includeKeys);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Model value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = Model.DeserializeModel(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteCustomModelRequest(Guid modelId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete Custom Model. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Mark model for deletion. Model artifacts will be permanently removed within a predetermined period. </remarks>
        public async Task<Response> DeleteCustomModelAsync(Guid modelId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteCustomModelRequest(modelId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete Custom Model. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Mark model for deletion. Model artifacts will be permanently removed within a predetermined period. </remarks>
        public Response DeleteCustomModel(Guid modelId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteCustomModelRequest(modelId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeWithCustomModelRequest(Guid modelId, InternalContentType contentType, bool? includeTextDetails, IEnumerable<string> pages, Stream fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath("/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(fileStream);
            }
            return message;
        }

        /// <summary> Analyze Form. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeWithCustomModelHeaders>> AnalyzeWithCustomModelAsync(Guid modelId, InternalContentType contentType, bool? includeTextDetails = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeWithCustomModelRequest(modelId, contentType, includeTextDetails, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeWithCustomModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Form. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeWithCustomModelHeaders> AnalyzeWithCustomModel(Guid modelId, InternalContentType contentType, bool? includeTextDetails = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeWithCustomModelRequest(modelId, contentType, includeTextDetails, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeWithCustomModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeWithCustomModelRequest(Guid modelId, bool? includeTextDetails, IEnumerable<string> pages, SourcePath fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath("/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(fileStream);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyze Form. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeWithCustomModelHeaders>> AnalyzeWithCustomModelAsync(Guid modelId, bool? includeTextDetails = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeWithCustomModelRequest(modelId, includeTextDetails, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeWithCustomModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Form. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeWithCustomModelHeaders> AnalyzeWithCustomModel(Guid modelId, bool? includeTextDetails = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeWithCustomModelRequest(modelId, includeTextDetails, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeWithCustomModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnalyzeFormResultRequest(Guid modelId, Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath("/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Analyze Form Result. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Obtain current status and the result of the analyze form operation. </remarks>
        public async Task<Response<AnalyzeOperationResult>> GetAnalyzeFormResultAsync(Guid modelId, Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeFormResultRequest(modelId, resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Analyze Form Result. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Obtain current status and the result of the analyze form operation. </remarks>
        public Response<AnalyzeOperationResult> GetAnalyzeFormResult(Guid modelId, Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeFormResultRequest(modelId, resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCopyCustomModelRequest(Guid modelId, CopyRequest copyRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath("/copy", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(copyRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Copy Custom Model. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="copyRequest"> Copy request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="copyRequest"/> is null. </exception>
        /// <remarks> Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerCopyCustomModelHeaders>> CopyCustomModelAsync(Guid modelId, CopyRequest copyRequest, CancellationToken cancellationToken = default)
        {
            if (copyRequest == null)
            {
                throw new ArgumentNullException(nameof(copyRequest));
            }

            using var message = CreateCopyCustomModelRequest(modelId, copyRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerCopyCustomModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Copy Custom Model. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="copyRequest"> Copy request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="copyRequest"/> is null. </exception>
        /// <remarks> Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource. </remarks>
        public ResponseWithHeaders<FormRecognizerCopyCustomModelHeaders> CopyCustomModel(Guid modelId, CopyRequest copyRequest, CancellationToken cancellationToken = default)
        {
            if (copyRequest == null)
            {
                throw new ArgumentNullException(nameof(copyRequest));
            }

            using var message = CreateCopyCustomModelRequest(modelId, copyRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerCopyCustomModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetCustomModelCopyResultRequest(Guid modelId, Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath("/copyResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Custom Model Copy Result. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="resultId"> Copy operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Obtain current status and the result of a custom model copy operation. </remarks>
        public async Task<Response<CopyOperationResult>> GetCustomModelCopyResultAsync(Guid modelId, Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCustomModelCopyResultRequest(modelId, resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CopyOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CopyOperationResult.DeserializeCopyOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Custom Model Copy Result. </summary>
        /// <param name="modelId"> Model identifier. </param>
        /// <param name="resultId"> Copy operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Obtain current status and the result of a custom model copy operation. </remarks>
        public Response<CopyOperationResult> GetCustomModelCopyResult(Guid modelId, Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCustomModelCopyResultRequest(modelId, resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CopyOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CopyOperationResult.DeserializeCopyOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGenerateModelCopyAuthorizationRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/copyAuthorization", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Generate Copy Authorization. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Generate authorization to copy a model into the target Form Recognizer resource. </remarks>
        public async Task<ResponseWithHeaders<CopyAuthorizationResult, FormRecognizerGenerateModelCopyAuthorizationHeaders>> GenerateModelCopyAuthorizationAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateGenerateModelCopyAuthorizationRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerGenerateModelCopyAuthorizationHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        CopyAuthorizationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CopyAuthorizationResult.DeserializeCopyAuthorizationResult(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Generate Copy Authorization. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Generate authorization to copy a model into the target Form Recognizer resource. </remarks>
        public ResponseWithHeaders<CopyAuthorizationResult, FormRecognizerGenerateModelCopyAuthorizationHeaders> GenerateModelCopyAuthorization(CancellationToken cancellationToken = default)
        {
            using var message = CreateGenerateModelCopyAuthorizationRequest();
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerGenerateModelCopyAuthorizationHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        CopyAuthorizationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CopyAuthorizationResult.DeserializeCopyAuthorizationResult(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateComposeCustomModelsAsyncRequest(ComposeRequest composeRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models/compose", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json, text/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(composeRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Compose trained with labels models into one composed model. </summary>
        /// <param name="composeRequest"> Compose models. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="composeRequest"/> is null. </exception>
        /// <remarks>
        /// Compose request would include list of models ids.
        /// It would validate what all models either trained with labels model or composed model.
        /// It would validate limit of models put together.
        /// </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerComposeCustomModelsAsyncHeaders>> ComposeCustomModelsAsyncAsync(ComposeRequest composeRequest, CancellationToken cancellationToken = default)
        {
            if (composeRequest == null)
            {
                throw new ArgumentNullException(nameof(composeRequest));
            }

            using var message = CreateComposeCustomModelsAsyncRequest(composeRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerComposeCustomModelsAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Compose trained with labels models into one composed model. </summary>
        /// <param name="composeRequest"> Compose models. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="composeRequest"/> is null. </exception>
        /// <remarks>
        /// Compose request would include list of models ids.
        /// It would validate what all models either trained with labels model or composed model.
        /// It would validate limit of models put together.
        /// </remarks>
        public ResponseWithHeaders<FormRecognizerComposeCustomModelsAsyncHeaders> ComposeCustomModelsAsync(ComposeRequest composeRequest, CancellationToken cancellationToken = default)
        {
            if (composeRequest == null)
            {
                throw new ArgumentNullException(nameof(composeRequest));
            }

            using var message = CreateComposeCustomModelsAsyncRequest(composeRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerComposeCustomModelsAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeBusinessCardAsyncRequest(InternalContentType contentType, bool? includeTextDetails, FormRecognizerLocale? locale, IEnumerable<string> pages, Stream fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/businessCard/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale.Value.ToString(), true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(fileStream);
            }
            return message;
        }

        /// <summary> Analyze Business Card. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given business card document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeBusinessCardAsyncHeaders>> AnalyzeBusinessCardAsyncAsync(InternalContentType contentType, bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeBusinessCardAsyncRequest(contentType, includeTextDetails, locale, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeBusinessCardAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Business Card. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given business card document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeBusinessCardAsyncHeaders> AnalyzeBusinessCardAsync(InternalContentType contentType, bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeBusinessCardAsyncRequest(contentType, includeTextDetails, locale, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeBusinessCardAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeBusinessCardAsyncRequest(bool? includeTextDetails, FormRecognizerLocale? locale, IEnumerable<string> pages, SourcePath fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/businessCard/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale.Value.ToString(), true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(fileStream);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyze Business Card. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given business card document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeBusinessCardAsyncHeaders>> AnalyzeBusinessCardAsyncAsync(bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeBusinessCardAsyncRequest(includeTextDetails, locale, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeBusinessCardAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Business Card. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given business card document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeBusinessCardAsyncHeaders> AnalyzeBusinessCardAsync(bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeBusinessCardAsyncRequest(includeTextDetails, locale, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeBusinessCardAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnalyzeBusinessCardResultRequest(Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/businessCard/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Analyze Business Card Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze business card operation. </remarks>
        public async Task<Response<AnalyzeOperationResult>> GetAnalyzeBusinessCardResultAsync(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeBusinessCardResultRequest(resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Analyze Business Card Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze business card operation. </remarks>
        public Response<AnalyzeOperationResult> GetAnalyzeBusinessCardResult(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeBusinessCardResultRequest(resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeInvoiceAsyncRequest(InternalContentType contentType, bool? includeTextDetails, FormRecognizerLocale? locale, IEnumerable<string> pages, Stream fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/invoice/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale.Value.ToString(), true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(fileStream);
            }
            return message;
        }

        /// <summary> Analyze Invoice Document. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given invoice document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeInvoiceAsyncHeaders>> AnalyzeInvoiceAsyncAsync(InternalContentType contentType, bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeInvoiceAsyncRequest(contentType, includeTextDetails, locale, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeInvoiceAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Invoice Document. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given invoice document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeInvoiceAsyncHeaders> AnalyzeInvoiceAsync(InternalContentType contentType, bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeInvoiceAsyncRequest(contentType, includeTextDetails, locale, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeInvoiceAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeInvoiceAsyncRequest(bool? includeTextDetails, FormRecognizerLocale? locale, IEnumerable<string> pages, SourcePath fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/invoice/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale.Value.ToString(), true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(fileStream);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyze Invoice Document. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given invoice document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeInvoiceAsyncHeaders>> AnalyzeInvoiceAsyncAsync(bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeInvoiceAsyncRequest(includeTextDetails, locale, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeInvoiceAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Invoice Document. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given invoice document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeInvoiceAsyncHeaders> AnalyzeInvoiceAsync(bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeInvoiceAsyncRequest(includeTextDetails, locale, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeInvoiceAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnalyzeInvoiceResultRequest(Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/invoice/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Analyze Invoice Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze invoice operation. </remarks>
        public async Task<Response<AnalyzeOperationResult>> GetAnalyzeInvoiceResultAsync(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeInvoiceResultRequest(resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Analyze Invoice Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze invoice operation. </remarks>
        public Response<AnalyzeOperationResult> GetAnalyzeInvoiceResult(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeInvoiceResultRequest(resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeIdDocumentAsyncRequest(InternalContentType contentType, bool? includeTextDetails, IEnumerable<string> pages, Stream fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/idDocument/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(fileStream);
            }
            return message;
        }

        /// <summary> Analyze ID Document. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given ID document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeIdDocumentAsyncHeaders>> AnalyzeIdDocumentAsyncAsync(InternalContentType contentType, bool? includeTextDetails = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeIdDocumentAsyncRequest(contentType, includeTextDetails, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeIdDocumentAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze ID Document. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given ID document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeIdDocumentAsyncHeaders> AnalyzeIdDocumentAsync(InternalContentType contentType, bool? includeTextDetails = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeIdDocumentAsyncRequest(contentType, includeTextDetails, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeIdDocumentAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeIdDocumentAsyncRequest(bool? includeTextDetails, IEnumerable<string> pages, SourcePath fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/idDocument/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(fileStream);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyze ID Document. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given ID document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeIdDocumentAsyncHeaders>> AnalyzeIdDocumentAsyncAsync(bool? includeTextDetails = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeIdDocumentAsyncRequest(includeTextDetails, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeIdDocumentAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze ID Document. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given ID document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeIdDocumentAsyncHeaders> AnalyzeIdDocumentAsync(bool? includeTextDetails = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeIdDocumentAsyncRequest(includeTextDetails, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeIdDocumentAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnalyzeIdDocumentResultRequest(Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/idDocument/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Analyze ID Document Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze ID operation. </remarks>
        public async Task<Response<AnalyzeOperationResult>> GetAnalyzeIdDocumentResultAsync(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeIdDocumentResultRequest(resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Analyze ID Document Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze ID operation. </remarks>
        public Response<AnalyzeOperationResult> GetAnalyzeIdDocumentResult(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeIdDocumentResultRequest(resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeReceiptAsyncRequest(InternalContentType contentType, bool? includeTextDetails, FormRecognizerLocale? locale, IEnumerable<string> pages, Stream fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/receipt/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale.Value.ToString(), true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(fileStream);
            }
            return message;
        }

        /// <summary> Analyze Receipt. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given receipt document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeReceiptAsyncHeaders>> AnalyzeReceiptAsyncAsync(InternalContentType contentType, bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeReceiptAsyncRequest(contentType, includeTextDetails, locale, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeReceiptAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Receipt. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given receipt document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeReceiptAsyncHeaders> AnalyzeReceiptAsync(InternalContentType contentType, bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeReceiptAsyncRequest(contentType, includeTextDetails, locale, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeReceiptAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeReceiptAsyncRequest(bool? includeTextDetails, FormRecognizerLocale? locale, IEnumerable<string> pages, SourcePath fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/receipt/analyze", false);
            if (includeTextDetails != null)
            {
                uri.AppendQuery("includeTextDetails", includeTextDetails.Value, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale.Value.ToString(), true);
            }
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(fileStream);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyze Receipt. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given receipt document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeReceiptAsyncHeaders>> AnalyzeReceiptAsyncAsync(bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeReceiptAsyncRequest(includeTextDetails, locale, pages, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeReceiptAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Receipt. </summary>
        /// <param name="includeTextDetails"> Include text lines and element references in the result. </param>
        /// <param name="locale"> Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US(default). </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract field text and semantic values from a given receipt document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeReceiptAsyncHeaders> AnalyzeReceiptAsync(bool? includeTextDetails = null, FormRecognizerLocale? locale = null, IEnumerable<string> pages = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeReceiptAsyncRequest(includeTextDetails, locale, pages, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeReceiptAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnalyzeReceiptResultRequest(Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/prebuilt/receipt/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Analyze Receipt Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze receipt operation. </remarks>
        public async Task<Response<AnalyzeOperationResult>> GetAnalyzeReceiptResultAsync(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeReceiptResultRequest(resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Analyze Receipt Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze receipt operation. </remarks>
        public Response<AnalyzeOperationResult> GetAnalyzeReceiptResult(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeReceiptResultRequest(resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeLayoutAsyncRequest(InternalContentType contentType, IEnumerable<string> pages, FormRecognizerLanguage? language, FormReadingOrder? readingOrder, Stream fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/layout/analyze", false);
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            if (language != null)
            {
                uri.AppendQuery("language", language.Value.ToString(), true);
            }
            if (readingOrder != null)
            {
                uri.AppendQuery("readingOrder", readingOrder.Value.ToSerialString(), true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(fileStream);
            }
            return message;
        }

        /// <summary> Analyze Layout. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="language"> Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English only). Layout supports auto language identification and multi language documents, so only provide a language code if you would like to force the documented to be processed as that specific language. </param>
        /// <param name="readingOrder"> Reading order algorithm to sort the text lines returned. Supported reading orders include: basic(default), natural. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract text and layout information from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeLayoutAsyncHeaders>> AnalyzeLayoutAsyncAsync(InternalContentType contentType, IEnumerable<string> pages = null, FormRecognizerLanguage? language = null, FormReadingOrder? readingOrder = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeLayoutAsyncRequest(contentType, pages, language, readingOrder, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeLayoutAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Layout. </summary>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="language"> Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English only). Layout supports auto language identification and multi language documents, so only provide a language code if you would like to force the documented to be processed as that specific language. </param>
        /// <param name="readingOrder"> Reading order algorithm to sort the text lines returned. Supported reading orders include: basic(default), natural. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract text and layout information from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeLayoutAsyncHeaders> AnalyzeLayoutAsync(InternalContentType contentType, IEnumerable<string> pages = null, FormRecognizerLanguage? language = null, FormReadingOrder? readingOrder = null, Stream fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeLayoutAsyncRequest(contentType, pages, language, readingOrder, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeLayoutAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAnalyzeLayoutAsyncRequest(IEnumerable<string> pages, FormRecognizerLanguage? language, FormReadingOrder? readingOrder, SourcePath fileStream)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/layout/analyze", false);
            if (pages != null && !(pages is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("pages", pages, ",", true);
            }
            if (language != null)
            {
                uri.AppendQuery("language", language.Value.ToString(), true);
            }
            if (readingOrder != null)
            {
                uri.AppendQuery("readingOrder", readingOrder.Value.ToSerialString(), true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (fileStream != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(fileStream);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyze Layout. </summary>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="language"> Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English only). Layout supports auto language identification and multi language documents, so only provide a language code if you would like to force the documented to be processed as that specific language. </param>
        /// <param name="readingOrder"> Reading order algorithm to sort the text lines returned. Supported reading orders include: basic(default), natural. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract text and layout information from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public async Task<ResponseWithHeaders<FormRecognizerAnalyzeLayoutAsyncHeaders>> AnalyzeLayoutAsyncAsync(IEnumerable<string> pages = null, FormRecognizerLanguage? language = null, FormReadingOrder? readingOrder = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeLayoutAsyncRequest(pages, language, readingOrder, fileStream);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new FormRecognizerAnalyzeLayoutAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyze Layout. </summary>
        /// <param name="pages"> Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma. </param>
        /// <param name="language"> Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English only). Layout supports auto language identification and multi language documents, so only provide a language code if you would like to force the documented to be processed as that specific language. </param>
        /// <param name="readingOrder"> Reading order algorithm to sort the text lines returned. Supported reading orders include: basic(default), natural. </param>
        /// <param name="fileStream"> .json, .pdf, .jpg, .png, .tiff or .bmp type file stream. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Extract text and layout information from a given document. The input document must be of one of the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be analyzed. </remarks>
        public ResponseWithHeaders<FormRecognizerAnalyzeLayoutAsyncHeaders> AnalyzeLayoutAsync(IEnumerable<string> pages = null, FormRecognizerLanguage? language = null, FormReadingOrder? readingOrder = null, SourcePath fileStream = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnalyzeLayoutAsyncRequest(pages, language, readingOrder, fileStream);
            _pipeline.Send(message, cancellationToken);
            var headers = new FormRecognizerAnalyzeLayoutAsyncHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnalyzeLayoutResultRequest(Guid resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/layout/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Analyze Layout Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze layout operation. </remarks>
        public async Task<Response<AnalyzeOperationResult>> GetAnalyzeLayoutResultAsync(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeLayoutResultRequest(resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Analyze Layout Result. </summary>
        /// <param name="resultId"> Analyze operation result identifier. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Track the progress and obtain the result of the analyze layout operation. </remarks>
        public Response<AnalyzeOperationResult> GetAnalyzeLayoutResult(Guid resultId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnalyzeLayoutResultRequest(resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeOperationResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeOperationResult.DeserializeAnalyzeOperationResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListCustomModelsRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models", false);
            uri.AppendQuery("op", "full", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List Custom Models. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Get information about all custom models. </remarks>
        public async Task<Response<Models.Models>> ListCustomModelsAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateListCustomModelsRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Models.Models value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = Models.Models.DeserializeModels(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List Custom Models. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Get information about all custom models. </remarks>
        public Response<Models.Models> ListCustomModels(CancellationToken cancellationToken = default)
        {
            using var message = CreateListCustomModelsRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Models.Models value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = Models.Models.DeserializeModels(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetCustomModelsRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendPath("/custom/models", false);
            uri.AppendQuery("op", "summary", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get Custom Models. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Get information about all custom models. </remarks>
        public async Task<Response<Models.Models>> GetCustomModelsAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCustomModelsRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Models.Models value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = Models.Models.DeserializeModels(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get Custom Models. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Get information about all custom models. </remarks>
        public Response<Models.Models> GetCustomModels(CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCustomModelsRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Models.Models value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = Models.Models.DeserializeModels(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListCustomModelsNextPageRequest(string nextLink)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/formrecognizer/", false);
            uri.AppendRaw(_apiVersion, false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List Custom Models. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        /// <remarks> Get information about all custom models. </remarks>
        public async Task<Response<Models.Models>> ListCustomModelsNextPageAsync(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListCustomModelsNextPageRequest(nextLink);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Models.Models value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = Models.Models.DeserializeModels(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List Custom Models. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        /// <remarks> Get information about all custom models. </remarks>
        public Response<Models.Models> ListCustomModelsNextPage(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListCustomModelsNextPageRequest(nextLink);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        Models.Models value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = Models.Models.DeserializeModels(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
