// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.IO;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    internal partial class DocumentAnalysisRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of DocumentAnalysisRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for
        /// example: https://westus2.api.cognitive.microsoft.com).
        /// </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        public DocumentAnalysisRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string apiVersion = "2023-07-31")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateDocumentModelsAnalyzeDocumentRequest(string modelId, string pages, string locale, StringIndexType? stringIndexType, IEnumerable<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath(":analyze", false);
            if (pages != null)
            {
                uri.AppendQuery("pages", pages, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale, true);
            }
            if (stringIndexType != null)
            {
                uri.AppendQuery("stringIndexType", stringIndexType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            if (features != null && !(features is ChangeTrackingList<DocumentAnalysisFeature> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("features", features, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (analyzeRequest != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(analyzeRequest);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Analyzes document with document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="pages"> List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". </param>
        /// <param name="locale"> Locale hint for text recognition and document analysis.  Value may contain only the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="features"> List of optional analysis features. </param>
        /// <param name="analyzeRequest"> Analyze request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders>> DocumentModelsAnalyzeDocumentAsync(string modelId, string pages = null, string locale = null, StringIndexType? stringIndexType = null, IEnumerable<DocumentAnalysisFeature> features = null, AnalyzeDocumentRequest analyzeRequest = null, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsAnalyzeDocumentRequest(modelId, pages, locale, stringIndexType, features, analyzeRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyzes document with document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="pages"> List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". </param>
        /// <param name="locale"> Locale hint for text recognition and document analysis.  Value may contain only the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="features"> List of optional analysis features. </param>
        /// <param name="analyzeRequest"> Analyze request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders> DocumentModelsAnalyzeDocument(string modelId, string pages = null, string locale = null, StringIndexType? stringIndexType = null, IEnumerable<DocumentAnalysisFeature> features = null, AnalyzeDocumentRequest analyzeRequest = null, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsAnalyzeDocumentRequest(modelId, pages, locale, stringIndexType, features, analyzeRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsAnalyzeDocumentRequest(string modelId, InternalContentType contentType, string pages, string locale, StringIndexType? stringIndexType, IEnumerable<DocumentAnalysisFeature> features, Stream analyzeRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath(":analyze", false);
            if (pages != null)
            {
                uri.AppendQuery("pages", pages, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale, true);
            }
            if (stringIndexType != null)
            {
                uri.AppendQuery("stringIndexType", stringIndexType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            if (features != null && !(features is ChangeTrackingList<DocumentAnalysisFeature> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("features", features, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (analyzeRequest != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(analyzeRequest);
            }
            return message;
        }

        /// <summary> Analyzes document with document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="pages"> List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". </param>
        /// <param name="locale"> Locale hint for text recognition and document analysis.  Value may contain only the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="features"> List of optional analysis features. </param>
        /// <param name="analyzeRequest"> Analyze request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders>> DocumentModelsAnalyzeDocumentAsync(string modelId, InternalContentType contentType, string pages = null, string locale = null, StringIndexType? stringIndexType = null, IEnumerable<DocumentAnalysisFeature> features = null, Stream analyzeRequest = null, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsAnalyzeDocumentRequest(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyzes document with document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="pages"> List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". </param>
        /// <param name="locale"> Locale hint for text recognition and document analysis.  Value may contain only the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="features"> List of optional analysis features. </param>
        /// <param name="analyzeRequest"> Analyze request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders> DocumentModelsAnalyzeDocument(string modelId, InternalContentType contentType, string pages = null, string locale = null, StringIndexType? stringIndexType = null, IEnumerable<DocumentAnalysisFeature> features = null, Stream analyzeRequest = null, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsAnalyzeDocumentRequest(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsAnalyzeDocumentRequest(string modelId, string pages, string locale, StringIndexType? stringIndexType, IEnumerable<DocumentAnalysisFeature> features, string analyzeRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath(":analyze", false);
            if (pages != null)
            {
                uri.AppendQuery("pages", pages, true);
            }
            if (locale != null)
            {
                uri.AppendQuery("locale", locale, true);
            }
            if (stringIndexType != null)
            {
                uri.AppendQuery("stringIndexType", stringIndexType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            if (features != null && !(features is ChangeTrackingList<DocumentAnalysisFeature> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("features", features, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (analyzeRequest != null)
            {
                request.Headers.Add("Content-Type", "text/html");
                request.Content = new StringRequestContent(analyzeRequest);
            }
            return message;
        }

        /// <summary> Analyzes document with document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="pages"> List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". </param>
        /// <param name="locale"> Locale hint for text recognition and document analysis.  Value may contain only the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="features"> List of optional analysis features. </param>
        /// <param name="analyzeRequest"> Analyze request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders>> DocumentModelsAnalyzeDocumentAsync(string modelId, string pages = null, string locale = null, StringIndexType? stringIndexType = null, IEnumerable<DocumentAnalysisFeature> features = null, string analyzeRequest = null, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsAnalyzeDocumentRequest(modelId, pages, locale, stringIndexType, features, analyzeRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Analyzes document with document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="pages"> List of 1-based page numbers to analyze.  Ex. "1-3,5,7-9". </param>
        /// <param name="locale"> Locale hint for text recognition and document analysis.  Value may contain only the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US"). </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="features"> List of optional analysis features. </param>
        /// <param name="analyzeRequest"> Analyze request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders> DocumentModelsAnalyzeDocument(string modelId, string pages = null, string locale = null, StringIndexType? stringIndexType = null, IEnumerable<DocumentAnalysisFeature> features = null, string analyzeRequest = null, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsAnalyzeDocumentRequest(modelId, pages, locale, stringIndexType, features, analyzeRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentModelsAnalyzeDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsGetAnalyzeResultRequest(string modelId, string resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath("/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets the result of document analysis. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="resultId"> Analyze operation result ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> or <paramref name="resultId"/> is null. </exception>
        public async Task<Response<AnalyzeResultOperation>> DocumentModelsGetAnalyzeResultAsync(string modelId, string resultId, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }
            if (resultId == null)
            {
                throw new ArgumentNullException(nameof(resultId));
            }

            using var message = CreateDocumentModelsGetAnalyzeResultRequest(modelId, resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeResultOperation value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeResultOperation.DeserializeAnalyzeResultOperation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the result of document analysis. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="resultId"> Analyze operation result ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> or <paramref name="resultId"/> is null. </exception>
        public Response<AnalyzeResultOperation> DocumentModelsGetAnalyzeResult(string modelId, string resultId, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }
            if (resultId == null)
            {
                throw new ArgumentNullException(nameof(resultId));
            }

            using var message = CreateDocumentModelsGetAnalyzeResultRequest(modelId, resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeResultOperation value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeResultOperation.DeserializeAnalyzeResultOperation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsBuildModelRequest(BuildDocumentModelRequest buildRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels:build", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(buildRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Builds a custom document analysis model. </summary>
        /// <param name="buildRequest"> Building request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="buildRequest"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentModelsBuildModelHeaders>> DocumentModelsBuildModelAsync(BuildDocumentModelRequest buildRequest, CancellationToken cancellationToken = default)
        {
            if (buildRequest == null)
            {
                throw new ArgumentNullException(nameof(buildRequest));
            }

            using var message = CreateDocumentModelsBuildModelRequest(buildRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentModelsBuildModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Builds a custom document analysis model. </summary>
        /// <param name="buildRequest"> Building request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="buildRequest"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentModelsBuildModelHeaders> DocumentModelsBuildModel(BuildDocumentModelRequest buildRequest, CancellationToken cancellationToken = default)
        {
            if (buildRequest == null)
            {
                throw new ArgumentNullException(nameof(buildRequest));
            }

            using var message = CreateDocumentModelsBuildModelRequest(buildRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentModelsBuildModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsComposeModelRequest(ComposeDocumentModelRequest composeRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels:compose", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(composeRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Creates a new document model from document types of existing document models. </summary>
        /// <param name="composeRequest"> Compose request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="composeRequest"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentModelsComposeModelHeaders>> DocumentModelsComposeModelAsync(ComposeDocumentModelRequest composeRequest, CancellationToken cancellationToken = default)
        {
            if (composeRequest == null)
            {
                throw new ArgumentNullException(nameof(composeRequest));
            }

            using var message = CreateDocumentModelsComposeModelRequest(composeRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentModelsComposeModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates a new document model from document types of existing document models. </summary>
        /// <param name="composeRequest"> Compose request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="composeRequest"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentModelsComposeModelHeaders> DocumentModelsComposeModel(ComposeDocumentModelRequest composeRequest, CancellationToken cancellationToken = default)
        {
            if (composeRequest == null)
            {
                throw new ArgumentNullException(nameof(composeRequest));
            }

            using var message = CreateDocumentModelsComposeModelRequest(composeRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentModelsComposeModelHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsAuthorizeModelCopyRequest(AuthorizeCopyRequest authorizeCopyRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels:authorizeCopy", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(authorizeCopyRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Generates authorization to copy a document model to this location with specified modelId and optional description. </summary>
        /// <param name="authorizeCopyRequest"> Authorize copy request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizeCopyRequest"/> is null. </exception>
        public async Task<Response<DocumentModelCopyAuthorization>> DocumentModelsAuthorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest, CancellationToken cancellationToken = default)
        {
            if (authorizeCopyRequest == null)
            {
                throw new ArgumentNullException(nameof(authorizeCopyRequest));
            }

            using var message = CreateDocumentModelsAuthorizeModelCopyRequest(authorizeCopyRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DocumentModelCopyAuthorization value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DocumentModelCopyAuthorization.DeserializeDocumentModelCopyAuthorization(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Generates authorization to copy a document model to this location with specified modelId and optional description. </summary>
        /// <param name="authorizeCopyRequest"> Authorize copy request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizeCopyRequest"/> is null. </exception>
        public Response<DocumentModelCopyAuthorization> DocumentModelsAuthorizeModelCopy(AuthorizeCopyRequest authorizeCopyRequest, CancellationToken cancellationToken = default)
        {
            if (authorizeCopyRequest == null)
            {
                throw new ArgumentNullException(nameof(authorizeCopyRequest));
            }

            using var message = CreateDocumentModelsAuthorizeModelCopyRequest(authorizeCopyRequest);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DocumentModelCopyAuthorization value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DocumentModelCopyAuthorization.DeserializeDocumentModelCopyAuthorization(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsCopyModelToRequest(string modelId, DocumentModelCopyAuthorization copyToRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendPath(":copyTo", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(copyToRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Copies document model to the target resource, region, and modelId. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="copyToRequest"> Copy to request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> or <paramref name="copyToRequest"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentModelsCopyModelToHeaders>> DocumentModelsCopyModelToAsync(string modelId, DocumentModelCopyAuthorization copyToRequest, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }
            if (copyToRequest == null)
            {
                throw new ArgumentNullException(nameof(copyToRequest));
            }

            using var message = CreateDocumentModelsCopyModelToRequest(modelId, copyToRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentModelsCopyModelToHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Copies document model to the target resource, region, and modelId. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="copyToRequest"> Copy to request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> or <paramref name="copyToRequest"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentModelsCopyModelToHeaders> DocumentModelsCopyModelTo(string modelId, DocumentModelCopyAuthorization copyToRequest, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }
            if (copyToRequest == null)
            {
                throw new ArgumentNullException(nameof(copyToRequest));
            }

            using var message = CreateDocumentModelsCopyModelToRequest(modelId, copyToRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentModelsCopyModelToHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateMiscellaneousListOperationsRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/operations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Lists all operations. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<GetOperationsResponse>> MiscellaneousListOperationsAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateMiscellaneousListOperationsRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetOperationsResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GetOperationsResponse.DeserializeGetOperationsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists all operations. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<GetOperationsResponse> MiscellaneousListOperations(CancellationToken cancellationToken = default)
        {
            using var message = CreateMiscellaneousListOperationsRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetOperationsResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GetOperationsResponse.DeserializeGetOperationsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateMiscellaneousGetOperationRequest(string operationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/operations/", false);
            uri.AppendPath(operationId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets operation info. </summary>
        /// <param name="operationId"> Unique operation ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        public async Task<Response<OperationDetails>> MiscellaneousGetOperationAsync(string operationId, CancellationToken cancellationToken = default)
        {
            if (operationId == null)
            {
                throw new ArgumentNullException(nameof(operationId));
            }

            using var message = CreateMiscellaneousGetOperationRequest(operationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        OperationDetails value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = OperationDetails.DeserializeOperationDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets operation info. </summary>
        /// <param name="operationId"> Unique operation ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        public Response<OperationDetails> MiscellaneousGetOperation(string operationId, CancellationToken cancellationToken = default)
        {
            if (operationId == null)
            {
                throw new ArgumentNullException(nameof(operationId));
            }

            using var message = CreateMiscellaneousGetOperationRequest(operationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        OperationDetails value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = OperationDetails.DeserializeOperationDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsListModelsRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all document models. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<GetDocumentModelsResponse>> DocumentModelsListModelsAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateDocumentModelsListModelsRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentModelsResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GetDocumentModelsResponse.DeserializeGetDocumentModelsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all document models. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<GetDocumentModelsResponse> DocumentModelsListModels(CancellationToken cancellationToken = default)
        {
            using var message = CreateDocumentModelsListModelsRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentModelsResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GetDocumentModelsResponse.DeserializeGetDocumentModelsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsGetModelRequest(string modelId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets detailed document model information. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public async Task<Response<DocumentModelDetails>> DocumentModelsGetModelAsync(string modelId, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsGetModelRequest(modelId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DocumentModelDetails value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DocumentModelDetails.DeserializeDocumentModelDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets detailed document model information. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public Response<DocumentModelDetails> DocumentModelsGetModel(string modelId, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsGetModelRequest(modelId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DocumentModelDetails value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DocumentModelDetails.DeserializeDocumentModelDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsDeleteModelRequest(string modelId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentModels/", false);
            uri.AppendPath(modelId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Deletes document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public async Task<Response> DocumentModelsDeleteModelAsync(string modelId, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsDeleteModelRequest(modelId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes document model. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public Response DocumentModelsDeleteModel(string modelId, CancellationToken cancellationToken = default)
        {
            if (modelId == null)
            {
                throw new ArgumentNullException(nameof(modelId));
            }

            using var message = CreateDocumentModelsDeleteModelRequest(modelId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersBuildClassifierRequest(BuildDocumentClassifierRequest buildRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers:build", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(buildRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Builds a custom document classifier. </summary>
        /// <param name="buildRequest"> Building request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="buildRequest"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentClassifiersBuildClassifierHeaders>> DocumentClassifiersBuildClassifierAsync(BuildDocumentClassifierRequest buildRequest, CancellationToken cancellationToken = default)
        {
            if (buildRequest == null)
            {
                throw new ArgumentNullException(nameof(buildRequest));
            }

            using var message = CreateDocumentClassifiersBuildClassifierRequest(buildRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentClassifiersBuildClassifierHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Builds a custom document classifier. </summary>
        /// <param name="buildRequest"> Building request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="buildRequest"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentClassifiersBuildClassifierHeaders> DocumentClassifiersBuildClassifier(BuildDocumentClassifierRequest buildRequest, CancellationToken cancellationToken = default)
        {
            if (buildRequest == null)
            {
                throw new ArgumentNullException(nameof(buildRequest));
            }

            using var message = CreateDocumentClassifiersBuildClassifierRequest(buildRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentClassifiersBuildClassifierHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersListClassifiersRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all document classifiers. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<GetDocumentClassifiersResponse>> DocumentClassifiersListClassifiersAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateDocumentClassifiersListClassifiersRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentClassifiersResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GetDocumentClassifiersResponse.DeserializeGetDocumentClassifiersResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all document classifiers. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<GetDocumentClassifiersResponse> DocumentClassifiersListClassifiers(CancellationToken cancellationToken = default)
        {
            using var message = CreateDocumentClassifiersListClassifiersRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentClassifiersResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GetDocumentClassifiersResponse.DeserializeGetDocumentClassifiersResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersGetClassifierRequest(string classifierId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers/", false);
            uri.AppendPath(classifierId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets detailed document classifier information. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public async Task<Response<DocumentClassifierDetails>> DocumentClassifiersGetClassifierAsync(string classifierId, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersGetClassifierRequest(classifierId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DocumentClassifierDetails value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DocumentClassifierDetails.DeserializeDocumentClassifierDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets detailed document classifier information. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public Response<DocumentClassifierDetails> DocumentClassifiersGetClassifier(string classifierId, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersGetClassifierRequest(classifierId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DocumentClassifierDetails value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DocumentClassifierDetails.DeserializeDocumentClassifierDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersDeleteClassifierRequest(string classifierId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers/", false);
            uri.AppendPath(classifierId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Deletes document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public async Task<Response> DocumentClassifiersDeleteClassifierAsync(string classifierId, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersDeleteClassifierRequest(classifierId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public Response DocumentClassifiersDeleteClassifier(string classifierId, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersDeleteClassifierRequest(classifierId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersClassifyDocumentRequest(string classifierId, StringIndexType? stringIndexType, ClassifyDocumentRequest classifyRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers/", false);
            uri.AppendPath(classifierId, true);
            uri.AppendPath(":analyze", false);
            if (stringIndexType != null)
            {
                uri.AppendQuery("stringIndexType", stringIndexType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (classifyRequest != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(classifyRequest);
                request.Content = content;
            }
            return message;
        }

        /// <summary> Classifies document with document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="classifyRequest"> Classify request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders>> DocumentClassifiersClassifyDocumentAsync(string classifierId, StringIndexType? stringIndexType = null, ClassifyDocumentRequest classifyRequest = null, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersClassifyDocumentRequest(classifierId, stringIndexType, classifyRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Classifies document with document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="classifyRequest"> Classify request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders> DocumentClassifiersClassifyDocument(string classifierId, StringIndexType? stringIndexType = null, ClassifyDocumentRequest classifyRequest = null, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersClassifyDocumentRequest(classifierId, stringIndexType, classifyRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersClassifyDocumentRequest(string classifierId, InternalContentType contentType, StringIndexType? stringIndexType, Stream classifyRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers/", false);
            uri.AppendPath(classifierId, true);
            uri.AppendPath(":analyze", false);
            if (stringIndexType != null)
            {
                uri.AppendQuery("stringIndexType", stringIndexType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (classifyRequest != null)
            {
                request.Headers.Add("Content-Type", contentType.ToSerialString());
                request.Content = RequestContent.Create(classifyRequest);
            }
            return message;
        }

        /// <summary> Classifies document with document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="classifyRequest"> Classify request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders>> DocumentClassifiersClassifyDocumentAsync(string classifierId, InternalContentType contentType, StringIndexType? stringIndexType = null, Stream classifyRequest = null, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersClassifyDocumentRequest(classifierId, contentType, stringIndexType, classifyRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Classifies document with document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="contentType"> Upload file type. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="classifyRequest"> Classify request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders> DocumentClassifiersClassifyDocument(string classifierId, InternalContentType contentType, StringIndexType? stringIndexType = null, Stream classifyRequest = null, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersClassifyDocumentRequest(classifierId, contentType, stringIndexType, classifyRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersClassifyDocumentRequest(string classifierId, StringIndexType? stringIndexType, string classifyRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers/", false);
            uri.AppendPath(classifierId, true);
            uri.AppendPath(":analyze", false);
            if (stringIndexType != null)
            {
                uri.AppendQuery("stringIndexType", stringIndexType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (classifyRequest != null)
            {
                request.Headers.Add("Content-Type", "text/html");
                request.Content = new StringRequestContent(classifyRequest);
            }
            return message;
        }

        /// <summary> Classifies document with document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="classifyRequest"> Classify request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public async Task<ResponseWithHeaders<DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders>> DocumentClassifiersClassifyDocumentAsync(string classifierId, StringIndexType? stringIndexType = null, string classifyRequest = null, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersClassifyDocumentRequest(classifierId, stringIndexType, classifyRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Classifies document with document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="classifyRequest"> Classify request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> is null. </exception>
        public ResponseWithHeaders<DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders> DocumentClassifiersClassifyDocument(string classifierId, StringIndexType? stringIndexType = null, string classifyRequest = null, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }

            using var message = CreateDocumentClassifiersClassifyDocumentRequest(classifierId, stringIndexType, classifyRequest);
            _pipeline.Send(message, cancellationToken);
            var headers = new DocumentAnalysisDocumentClassifiersClassifyDocumentHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersGetClassifyResultRequest(string classifierId, string resultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/documentClassifiers/", false);
            uri.AppendPath(classifierId, true);
            uri.AppendPath("/analyzeResults/", false);
            uri.AppendPath(resultId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets the result of document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="resultId"> Analyze operation result ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> or <paramref name="resultId"/> is null. </exception>
        public async Task<Response<AnalyzeResultOperation>> DocumentClassifiersGetClassifyResultAsync(string classifierId, string resultId, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }
            if (resultId == null)
            {
                throw new ArgumentNullException(nameof(resultId));
            }

            using var message = CreateDocumentClassifiersGetClassifyResultRequest(classifierId, resultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeResultOperation value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnalyzeResultOperation.DeserializeAnalyzeResultOperation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the result of document classifier. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="resultId"> Analyze operation result ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="classifierId"/> or <paramref name="resultId"/> is null. </exception>
        public Response<AnalyzeResultOperation> DocumentClassifiersGetClassifyResult(string classifierId, string resultId, CancellationToken cancellationToken = default)
        {
            if (classifierId == null)
            {
                throw new ArgumentNullException(nameof(classifierId));
            }
            if (resultId == null)
            {
                throw new ArgumentNullException(nameof(resultId));
            }

            using var message = CreateDocumentClassifiersGetClassifyResultRequest(classifierId, resultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnalyzeResultOperation value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnalyzeResultOperation.DeserializeAnalyzeResultOperation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateMiscellaneousGetResourceInfoRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendPath("/info", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Return information about the current resource. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<ServiceResourceDetails>> MiscellaneousGetResourceInfoAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateMiscellaneousGetResourceInfoRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ServiceResourceDetails value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ServiceResourceDetails.DeserializeServiceResourceDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Return information about the current resource. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<ServiceResourceDetails> MiscellaneousGetResourceInfo(CancellationToken cancellationToken = default)
        {
            using var message = CreateMiscellaneousGetResourceInfoRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ServiceResourceDetails value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ServiceResourceDetails.DeserializeServiceResourceDetails(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateMiscellaneousListOperationsNextPageRequest(string nextLink)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Lists all operations. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<GetOperationsResponse>> MiscellaneousListOperationsNextPageAsync(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateMiscellaneousListOperationsNextPageRequest(nextLink);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetOperationsResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GetOperationsResponse.DeserializeGetOperationsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists all operations. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<GetOperationsResponse> MiscellaneousListOperationsNextPage(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateMiscellaneousListOperationsNextPageRequest(nextLink);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetOperationsResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GetOperationsResponse.DeserializeGetOperationsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentModelsListModelsNextPageRequest(string nextLink)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all document models. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<GetDocumentModelsResponse>> DocumentModelsListModelsNextPageAsync(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateDocumentModelsListModelsNextPageRequest(nextLink);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentModelsResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GetDocumentModelsResponse.DeserializeGetDocumentModelsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all document models. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<GetDocumentModelsResponse> DocumentModelsListModelsNextPage(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateDocumentModelsListModelsNextPageRequest(nextLink);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentModelsResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GetDocumentModelsResponse.DeserializeGetDocumentModelsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDocumentClassifiersListClassifiersNextPageRequest(string nextLink)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/formrecognizer", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all document classifiers. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<GetDocumentClassifiersResponse>> DocumentClassifiersListClassifiersNextPageAsync(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateDocumentClassifiersListClassifiersNextPageRequest(nextLink);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentClassifiersResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GetDocumentClassifiersResponse.DeserializeGetDocumentClassifiersResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all document classifiers. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<GetDocumentClassifiersResponse> DocumentClassifiersListClassifiersNextPage(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateDocumentClassifiersListClassifiersNextPageRequest(nextLink);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GetDocumentClassifiersResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GetDocumentClassifiersResponse.DeserializeGetDocumentClassifiersResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
