// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FluidRelay.Models
{
    /// <summary> Sku of the storage associated with the resource. </summary>
    public readonly partial struct FluidRelayStorageSku : IEquatable<FluidRelayStorageSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FluidRelayStorageSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FluidRelayStorageSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "standard";
        private const string BasicValue = "basic";

        /// <summary> standard. </summary>
        public static FluidRelayStorageSku Standard { get; } = new FluidRelayStorageSku(StandardValue);
        /// <summary> basic. </summary>
        public static FluidRelayStorageSku Basic { get; } = new FluidRelayStorageSku(BasicValue);
        /// <summary> Determines if two <see cref="FluidRelayStorageSku"/> values are the same. </summary>
        public static bool operator ==(FluidRelayStorageSku left, FluidRelayStorageSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FluidRelayStorageSku"/> values are not the same. </summary>
        public static bool operator !=(FluidRelayStorageSku left, FluidRelayStorageSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FluidRelayStorageSku"/>. </summary>
        public static implicit operator FluidRelayStorageSku(string value) => new FluidRelayStorageSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FluidRelayStorageSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FluidRelayStorageSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
