// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.FluidRelay.Models
{
    /// <summary> The set of available keys for this server. </summary>
    public partial class FluidRelayServerKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FluidRelayServerKeys"/>. </summary>
        internal FluidRelayServerKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FluidRelayServerKeys"/>. </summary>
        /// <param name="primaryKey"> The primary key for this server. </param>
        /// <param name="secondaryKey"> The secondary key for this server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FluidRelayServerKeys(string primaryKey, string secondaryKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimaryKey = primaryKey;
            SecondaryKey = secondaryKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The primary key for this server. </summary>
        public string PrimaryKey { get; }
        /// <summary> The secondary key for this server. </summary>
        public string SecondaryKey { get; }
    }
}
