// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.FluidRelay.Models
{
    internal static partial class FluidRelayKeyNameExtensions
    {
        public static string ToSerialString(this FluidRelayKeyName value) => value switch
        {
            FluidRelayKeyName.PrimaryKey => "key1",
            FluidRelayKeyName.SecondaryKey => "key2",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FluidRelayKeyName value.")
        };

        public static FluidRelayKeyName ToFluidRelayKeyName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "key1")) return FluidRelayKeyName.PrimaryKey;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "key2")) return FluidRelayKeyName.SecondaryKey;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FluidRelayKeyName value.");
        }
    }
}
