// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.FluidRelay.Models
{
    /// <summary> The Fluid Relay endpoints for this server. </summary>
    public partial class FluidRelayEndpoints
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FluidRelayEndpoints"/>. </summary>
        internal FluidRelayEndpoints()
        {
            OrdererEndpoints = new ChangeTrackingList<string>();
            StorageEndpoints = new ChangeTrackingList<string>();
            ServiceEndpoints = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="FluidRelayEndpoints"/>. </summary>
        /// <param name="ordererEndpoints"> The Fluid Relay Orderer endpoints. </param>
        /// <param name="storageEndpoints"> The Fluid Relay storage endpoints. </param>
        /// <param name="serviceEndpoints"> The Fluid Relay service endpoints. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FluidRelayEndpoints(IReadOnlyList<string> ordererEndpoints, IReadOnlyList<string> storageEndpoints, IReadOnlyList<string> serviceEndpoints, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OrdererEndpoints = ordererEndpoints;
            StorageEndpoints = storageEndpoints;
            ServiceEndpoints = serviceEndpoints;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Fluid Relay Orderer endpoints. </summary>
        public IReadOnlyList<string> OrdererEndpoints { get; }
        /// <summary> The Fluid Relay storage endpoints. </summary>
        public IReadOnlyList<string> StorageEndpoints { get; }
        /// <summary> The Fluid Relay service endpoints. </summary>
        public IReadOnlyList<string> ServiceEndpoints { get; }
    }
}
