// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.FluidRelay.Models
{
    internal static partial class CmkIdentityTypeExtensions
    {
        public static string ToSerialString(this CmkIdentityType value) => value switch
        {
            CmkIdentityType.SystemAssigned => "SystemAssigned",
            CmkIdentityType.UserAssigned => "UserAssigned",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CmkIdentityType value.")
        };

        public static CmkIdentityType ToCmkIdentityType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SystemAssigned")) return CmkIdentityType.SystemAssigned;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UserAssigned")) return CmkIdentityType.UserAssigned;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CmkIdentityType value.");
        }
    }
}
