// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.FluidRelay.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.FluidRelay
{
    /// <summary>
    /// A class representing the FluidRelayServer data model.
    /// A FluidRelay Server.
    /// </summary>
    public partial class FluidRelayServerData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FluidRelayServerData"/>. </summary>
        /// <param name="location"> The location. </param>
        public FluidRelayServerData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="FluidRelayServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The type of identity used for the resource. </param>
        /// <param name="frsTenantId"> The Fluid tenantId for this server. </param>
        /// <param name="fluidRelayEndpoints"> The Fluid Relay Service endpoints for this server. </param>
        /// <param name="provisioningState"> Provision states for FluidRelay RP. </param>
        /// <param name="encryption"> All encryption configuration for a resource. </param>
        /// <param name="storageSku"> Sku of the storage associated with the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FluidRelayServerData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, Guid? frsTenantId, FluidRelayEndpoints fluidRelayEndpoints, FluidRelayProvisioningState? provisioningState, Models.EncryptionProperties encryption, FluidRelayStorageSku? storageSku, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            FrsTenantId = frsTenantId;
            FluidRelayEndpoints = fluidRelayEndpoints;
            ProvisioningState = provisioningState;
            Encryption = encryption;
            StorageSku = storageSku;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FluidRelayServerData"/> for deserialization. </summary>
        internal FluidRelayServerData()
        {
        }

        /// <summary> The type of identity used for the resource. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The Fluid tenantId for this server. </summary>
        public Guid? FrsTenantId { get; }
        /// <summary> The Fluid Relay Service endpoints for this server. </summary>
        public FluidRelayEndpoints FluidRelayEndpoints { get; }
        /// <summary> Provision states for FluidRelay RP. </summary>
        public FluidRelayProvisioningState? ProvisioningState { get; set; }
        /// <summary> All encryption configuration for a resource. </summary>
        internal Models.EncryptionProperties Encryption { get; set; }
        /// <summary> All Customer-managed key encryption properties for the resource. </summary>
        public CmkEncryptionProperties CustomerManagedKeyEncryption
        {
            get => Encryption is null ? default : Encryption.CustomerManagedKeyEncryption;
            set
            {
                if (Encryption is null)
                    Encryption = new Models.EncryptionProperties();
                Encryption.CustomerManagedKeyEncryption = value;
            }
        }

        /// <summary> Sku of the storage associated with the resource. </summary>
        public FluidRelayStorageSku? StorageSku { get; set; }
    }
}
