// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.FluidRelay.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableFluidRelayArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableFluidRelayArmClient"/> class for mocking. </summary>
        protected MockableFluidRelayArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableFluidRelayArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableFluidRelayArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableFluidRelayArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="FluidRelayServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FluidRelayServerResource.CreateResourceIdentifier" /> to create a <see cref="FluidRelayServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FluidRelayServerResource"/> object. </returns>
        public virtual FluidRelayServerResource GetFluidRelayServerResource(ResourceIdentifier id)
        {
            FluidRelayServerResource.ValidateResourceId(id);
            return new FluidRelayServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FluidRelayContainerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FluidRelayContainerResource.CreateResourceIdentifier" /> to create a <see cref="FluidRelayContainerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FluidRelayContainerResource"/> object. </returns>
        public virtual FluidRelayContainerResource GetFluidRelayContainerResource(ResourceIdentifier id)
        {
            FluidRelayContainerResource.ValidateResourceId(id);
            return new FluidRelayContainerResource(Client, id);
        }
    }
}
