// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.FluidRelay.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.FluidRelay.Samples
{
    public partial class Sample_FluidRelayServerResource
    {
        // Get Fluid Relay server details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetFluidRelayServerDetails()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Get.json
            // this example is just showing the usage of "FluidRelayServers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FluidRelayServerResource created on azure
            // for more information of creating FluidRelayServerResource, please refer to the document of FluidRelayServerResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            string fluidRelayServerName = "myFluidRelayServer";
            ResourceIdentifier fluidRelayServerResourceId = FluidRelayServerResource.CreateResourceIdentifier(subscriptionId, resourceGroup, fluidRelayServerName);
            FluidRelayServerResource fluidRelayServer = client.GetFluidRelayServerResource(fluidRelayServerResourceId);

            // invoke the operation
            FluidRelayServerResource result = await fluidRelayServer.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FluidRelayServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a Fluid Relay server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAFluidRelayServer()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Update.json
            // this example is just showing the usage of "FluidRelayServers_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FluidRelayServerResource created on azure
            // for more information of creating FluidRelayServerResource, please refer to the document of FluidRelayServerResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            string fluidRelayServerName = "myFluidRelayServer";
            ResourceIdentifier fluidRelayServerResourceId = FluidRelayServerResource.CreateResourceIdentifier(subscriptionId, resourceGroup, fluidRelayServerName);
            FluidRelayServerResource fluidRelayServer = client.GetFluidRelayServerResource(fluidRelayServerResourceId);

            // invoke the operation
            FluidRelayServerPatch patch = new FluidRelayServerPatch()
            {
                Tags =
{
["Category"] = "sales",
},
            };
            FluidRelayServerResource result = await fluidRelayServer.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FluidRelayServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a Fluid Relay server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAFluidRelayServer()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Delete.json
            // this example is just showing the usage of "FluidRelayServers_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FluidRelayServerResource created on azure
            // for more information of creating FluidRelayServerResource, please refer to the document of FluidRelayServerResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            string fluidRelayServerName = "myFluidRelayServer";
            ResourceIdentifier fluidRelayServerResourceId = FluidRelayServerResource.CreateResourceIdentifier(subscriptionId, resourceGroup, fluidRelayServerName);
            FluidRelayServerResource fluidRelayServer = client.GetFluidRelayServerResource(fluidRelayServerResourceId);

            // invoke the operation
            await fluidRelayServer.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Regenerate keys for a Fluid Relay server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegenerateKeys_RegenerateKeysForAFluidRelayServer()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_RegenerateKeys.json
            // this example is just showing the usage of "FluidRelayServers_RegenerateKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FluidRelayServerResource created on azure
            // for more information of creating FluidRelayServerResource, please refer to the document of FluidRelayServerResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            string fluidRelayServerName = "myFluidRelayServer";
            ResourceIdentifier fluidRelayServerResourceId = FluidRelayServerResource.CreateResourceIdentifier(subscriptionId, resourceGroup, fluidRelayServerName);
            FluidRelayServerResource fluidRelayServer = client.GetFluidRelayServerResource(fluidRelayServerResourceId);

            // invoke the operation
            RegenerateKeyContent content = new RegenerateKeyContent(FluidRelayKeyName.PrimaryKey);
            FluidRelayServerKeys result = await fluidRelayServer.RegenerateKeysAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get keys for a Fluid Relay server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_GetKeysForAFluidRelayServer()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_ListKeys.json
            // this example is just showing the usage of "FluidRelayServers_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FluidRelayServerResource created on azure
            // for more information of creating FluidRelayServerResource, please refer to the document of FluidRelayServerResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            string fluidRelayServerName = "myFluidRelayServer";
            ResourceIdentifier fluidRelayServerResourceId = FluidRelayServerResource.CreateResourceIdentifier(subscriptionId, resourceGroup, fluidRelayServerName);
            FluidRelayServerResource fluidRelayServer = client.GetFluidRelayServerResource(fluidRelayServerResourceId);

            // invoke the operation
            FluidRelayServerKeys result = await fluidRelayServer.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // List all Fluid Relay servers in a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetFluidRelayServers_ListAllFluidRelayServersInASubscription()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_ListBySubscription.json
            // this example is just showing the usage of "FluidRelayServers_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (FluidRelayServerResource item in subscriptionResource.GetFluidRelayServersAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FluidRelayServerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
