// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.FluidRelay.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.FluidRelay.Samples
{
    public partial class Sample_FluidRelayServerCollection
    {
        // Get Fluid Relay server details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetFluidRelayServerDetails()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Get.json
            // this example is just showing the usage of "FluidRelayServers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation
            string fluidRelayServerName = "myFluidRelayServer";
            FluidRelayServerResource result = await collection.GetAsync(fluidRelayServerName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FluidRelayServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Fluid Relay server details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetFluidRelayServerDetails()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Get.json
            // this example is just showing the usage of "FluidRelayServers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation
            string fluidRelayServerName = "myFluidRelayServer";
            bool result = await collection.ExistsAsync(fluidRelayServerName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Fluid Relay server details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetFluidRelayServerDetails()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Get.json
            // this example is just showing the usage of "FluidRelayServers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation
            string fluidRelayServerName = "myFluidRelayServer";
            NullableResponse<FluidRelayServerResource> response = await collection.GetIfExistsAsync(fluidRelayServerName);
            FluidRelayServerResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FluidRelayServerData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a Fluid Relay server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAFluidRelayServer()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_CreateOrUpdate.json
            // this example is just showing the usage of "FluidRelayServers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation
            string fluidRelayServerName = "myFluidRelayServer";
            FluidRelayServerData data = new FluidRelayServerData(new AzureLocation("west-us"))
            {
                Identity = new ManagedServiceIdentity("SystemAssigned"),
                StorageSku = FluidRelayStorageSku.Basic,
                Tags =
{
["Category"] = "sales",
},
            };
            ArmOperation<FluidRelayServerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, fluidRelayServerName, data);
            FluidRelayServerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FluidRelayServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a Fluid Relay server with AMI
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAFluidRelayServerWithAMI()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_CreateWithAmi.json
            // this example is just showing the usage of "FluidRelayServers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation
            string fluidRelayServerName = "myFluidRelayServer";
            FluidRelayServerData data = new FluidRelayServerData(new AzureLocation("west-us"))
            {
                Identity = new ManagedServiceIdentity("SystemAssigned, UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1")] = new UserAssignedIdentity(),
[new ResourceIdentifier("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2")] = new UserAssignedIdentity(),
},
                },
                StorageSku = FluidRelayStorageSku.Basic,
                Tags =
{
["Category"] = "sales",
},
            };
            ArmOperation<FluidRelayServerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, fluidRelayServerName, data);
            FluidRelayServerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FluidRelayServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a Fluid Relay server with CMK
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAFluidRelayServerWithCMK()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_CreateWithCmk.json
            // this example is just showing the usage of "FluidRelayServers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation
            string fluidRelayServerName = "myFluidRelayServer";
            FluidRelayServerData data = new FluidRelayServerData(new AzureLocation("west-us"))
            {
                Identity = new ManagedServiceIdentity("UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityForCMK")] = new UserAssignedIdentity(),
},
                },
                CustomerManagedKeyEncryption = new CmkEncryptionProperties()
                {
                    KeyEncryptionKeyIdentity = new CmkIdentity()
                    {
                        IdentityType = CmkIdentityType.UserAssigned,
                        UserAssignedIdentityResourceId = new ResourceIdentifier("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityForCMK"),
                    },
                    KeyEncryptionKeyUri = new Uri("https://contosovault.vault.azure.net/keys/contosokek"),
                },
                StorageSku = FluidRelayStorageSku.Basic,
                Tags =
{
["Category"] = "sales",
},
            };
            ArmOperation<FluidRelayServerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, fluidRelayServerName, data);
            FluidRelayServerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FluidRelayServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List all Fluid Relay servers in a resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllFluidRelayServersInAResourceGroup()
        {
            // Generated from example definition: specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_ListByResourceGroup.json
            // this example is just showing the usage of "FluidRelayServers_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "xxxx-xxxx-xxxx-xxxx";
            string resourceGroup = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroup);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this FluidRelayServerResource
            FluidRelayServerCollection collection = resourceGroupResource.GetFluidRelayServers();

            // invoke the operation and iterate over the result
            await foreach (FluidRelayServerResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FluidRelayServerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
