// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The node image upgrade to be applied to the target nodes in update run. </summary>
    public partial class NodeImageSelection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NodeImageSelection"/>. </summary>
        /// <param name="selectionType"> The node image upgrade type. </param>
        public NodeImageSelection(NodeImageSelectionType selectionType)
        {
            SelectionType = selectionType;
            CustomNodeImageVersions = new ChangeTrackingList<NodeImageVersion>();
        }

        /// <summary> Initializes a new instance of <see cref="NodeImageSelection"/>. </summary>
        /// <param name="selectionType"> The node image upgrade type. </param>
        /// <param name="customNodeImageVersions"> Custom node image versions to upgrade the nodes to. This field is required if node image selection type is Custom. Otherwise, it must be empty. For each node image family (e.g., 'AKSUbuntu-1804gen2containerd'), this field can contain at most one version (e.g., only one of 'AKSUbuntu-1804gen2containerd-2023.01.12' or 'AKSUbuntu-1804gen2containerd-2023.02.12', not both). If the nodes belong to a family without a matching image version in this field, they are not upgraded. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NodeImageSelection(NodeImageSelectionType selectionType, IList<NodeImageVersion> customNodeImageVersions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SelectionType = selectionType;
            CustomNodeImageVersions = customNodeImageVersions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NodeImageSelection"/> for deserialization. </summary>
        internal NodeImageSelection()
        {
        }

        /// <summary> The node image upgrade type. </summary>
        public NodeImageSelectionType SelectionType { get; set; }
        /// <summary> Custom node image versions to upgrade the nodes to. This field is required if node image selection type is Custom. Otherwise, it must be empty. For each node image family (e.g., 'AKSUbuntu-1804gen2containerd'), this field can contain at most one version (e.g., only one of 'AKSUbuntu-1804gen2containerd-2023.01.12' or 'AKSUbuntu-1804gen2containerd-2023.02.12', not both). If the nodes belong to a family without a matching image version in this field, they are not upgraded. </summary>
        public IList<NodeImageVersion> CustomNodeImageVersions { get; }
    }
}
