// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The provisioning state of the last accepted operation. </summary>
    public readonly partial struct FleetProvisioningState : IEquatable<FleetProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FleetProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FleetProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";

        /// <summary> Resource has been created. </summary>
        public static FleetProvisioningState Succeeded { get; } = new FleetProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static FleetProvisioningState Failed { get; } = new FleetProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static FleetProvisioningState Canceled { get; } = new FleetProvisioningState(CanceledValue);
        /// <summary> The provisioning state of a fleet being created. </summary>
        public static FleetProvisioningState Creating { get; } = new FleetProvisioningState(CreatingValue);
        /// <summary> The provisioning state of a fleet being updated. </summary>
        public static FleetProvisioningState Updating { get; } = new FleetProvisioningState(UpdatingValue);
        /// <summary> The provisioning state of a fleet being deleted. </summary>
        public static FleetProvisioningState Deleting { get; } = new FleetProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="FleetProvisioningState"/> values are the same. </summary>
        public static bool operator ==(FleetProvisioningState left, FleetProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FleetProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(FleetProvisioningState left, FleetProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FleetProvisioningState"/>. </summary>
        public static implicit operator FleetProvisioningState(string value) => new FleetProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FleetProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FleetProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
