// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The provisioning state of the last accepted operation. </summary>
    public readonly partial struct FleetMemberProvisioningState : IEquatable<FleetMemberProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FleetMemberProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FleetMemberProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string JoiningValue = "Joining";
        private const string LeavingValue = "Leaving";
        private const string UpdatingValue = "Updating";

        /// <summary> Resource has been created. </summary>
        public static FleetMemberProvisioningState Succeeded { get; } = new FleetMemberProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static FleetMemberProvisioningState Failed { get; } = new FleetMemberProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static FleetMemberProvisioningState Canceled { get; } = new FleetMemberProvisioningState(CanceledValue);
        /// <summary> The provisioning state of a member joining a fleet. </summary>
        public static FleetMemberProvisioningState Joining { get; } = new FleetMemberProvisioningState(JoiningValue);
        /// <summary> The provisioning state of a member leaving a fleet. </summary>
        public static FleetMemberProvisioningState Leaving { get; } = new FleetMemberProvisioningState(LeavingValue);
        /// <summary> The provisioning state of a member being updated. </summary>
        public static FleetMemberProvisioningState Updating { get; } = new FleetMemberProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="FleetMemberProvisioningState"/> values are the same. </summary>
        public static bool operator ==(FleetMemberProvisioningState left, FleetMemberProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FleetMemberProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(FleetMemberProvisioningState left, FleetMemberProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FleetMemberProvisioningState"/>. </summary>
        public static implicit operator FleetMemberProvisioningState(string value) => new FleetMemberProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FleetMemberProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FleetMemberProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
