// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The FleetHubProfile configures the fleet hub. </summary>
    public partial class FleetHubProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FleetHubProfile"/>. </summary>
        public FleetHubProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FleetHubProfile"/>. </summary>
        /// <param name="dnsPrefix"> DNS prefix used to create the FQDN for the Fleet hub. </param>
        /// <param name="apiServerAccessProfile"> The access profile for the Fleet hub API server. </param>
        /// <param name="agentProfile"> The agent profile for the Fleet hub. </param>
        /// <param name="fqdn"> The FQDN of the Fleet hub. </param>
        /// <param name="kubernetesVersion"> The Kubernetes version of the Fleet hub. </param>
        /// <param name="portalFqdn"> The Azure Portal FQDN of the Fleet hub. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FleetHubProfile(string dnsPrefix, ContainerServiceFleetAPIServerAccessProfile apiServerAccessProfile, ContainerServiceFleetAgentProfile agentProfile, string fqdn, string kubernetesVersion, string portalFqdn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DnsPrefix = dnsPrefix;
            ApiServerAccessProfile = apiServerAccessProfile;
            AgentProfile = agentProfile;
            Fqdn = fqdn;
            KubernetesVersion = kubernetesVersion;
            PortalFqdn = portalFqdn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> DNS prefix used to create the FQDN for the Fleet hub. </summary>
        public string DnsPrefix { get; set; }
        /// <summary> The access profile for the Fleet hub API server. </summary>
        public ContainerServiceFleetAPIServerAccessProfile ApiServerAccessProfile { get; set; }
        /// <summary> The agent profile for the Fleet hub. </summary>
        public ContainerServiceFleetAgentProfile AgentProfile { get; set; }
        /// <summary> The FQDN of the Fleet hub. </summary>
        public string Fqdn { get; }
        /// <summary> The Kubernetes version of the Fleet hub. </summary>
        public string KubernetesVersion { get; }
        /// <summary> The Azure Portal FQDN of the Fleet hub. </summary>
        public string PortalFqdn { get; }
    }
}
