// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The status for an operation or group of operations. </summary>
    public partial class ContainerServiceFleetUpdateStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateStatus"/>. </summary>
        internal ContainerServiceFleetUpdateStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateStatus"/>. </summary>
        /// <param name="startOn"> The time the operation or group was started. </param>
        /// <param name="completedOn"> The time the operation or group was completed. </param>
        /// <param name="state"> The State of the operation or group. </param>
        /// <param name="error"> The error details when a failure is encountered. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceFleetUpdateStatus(DateTimeOffset? startOn, DateTimeOffset? completedOn, ContainerServiceFleetUpdateState? state, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            CompletedOn = completedOn;
            State = state;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The time the operation or group was started. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The time the operation or group was completed. </summary>
        public DateTimeOffset? CompletedOn { get; }
        /// <summary> The State of the operation or group. </summary>
        public ContainerServiceFleetUpdateState? State { get; }
        /// <summary> The error details when a failure is encountered. </summary>
        public ResponseError Error { get; }
    }
}
