// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The status of a UpdateStage. </summary>
    public partial class ContainerServiceFleetUpdateStageStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateStageStatus"/>. </summary>
        internal ContainerServiceFleetUpdateStageStatus()
        {
            Groups = new ChangeTrackingList<ContainerServiceFleetUpdateGroupStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateStageStatus"/>. </summary>
        /// <param name="status"> The status of the UpdateStage. </param>
        /// <param name="name"> The name of the UpdateStage. </param>
        /// <param name="groups"> The list of groups to be updated as part of this UpdateStage. </param>
        /// <param name="afterStageWaitStatus"> The status of the wait period configured on the UpdateStage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceFleetUpdateStageStatus(ContainerServiceFleetUpdateStatus status, string name, IReadOnlyList<ContainerServiceFleetUpdateGroupStatus> groups, ContainerServiceFleetWaitStatus afterStageWaitStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Name = name;
            Groups = groups;
            AfterStageWaitStatus = afterStageWaitStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the UpdateStage. </summary>
        public ContainerServiceFleetUpdateStatus Status { get; }
        /// <summary> The name of the UpdateStage. </summary>
        public string Name { get; }
        /// <summary> The list of groups to be updated as part of this UpdateStage. </summary>
        public IReadOnlyList<ContainerServiceFleetUpdateGroupStatus> Groups { get; }
        /// <summary> The status of the wait period configured on the UpdateStage. </summary>
        public ContainerServiceFleetWaitStatus AfterStageWaitStatus { get; }
    }
}
