// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The status of a UpdateRun. </summary>
    public partial class ContainerServiceFleetUpdateRunStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateRunStatus"/>. </summary>
        internal ContainerServiceFleetUpdateRunStatus()
        {
            Stages = new ChangeTrackingList<ContainerServiceFleetUpdateStageStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateRunStatus"/>. </summary>
        /// <param name="status"> The status of the UpdateRun. </param>
        /// <param name="stages"> The stages composing an update run. Stages are run sequentially withing an UpdateRun. </param>
        /// <param name="nodeImageSelection"> The node image upgrade specs for the update run. It is only set in update run when `NodeImageSelection.type` is `Consistent`. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceFleetUpdateRunStatus(ContainerServiceFleetUpdateStatus status, IReadOnlyList<ContainerServiceFleetUpdateStageStatus> stages, NodeImageSelectionStatus nodeImageSelection, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Stages = stages;
            NodeImageSelection = nodeImageSelection;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the UpdateRun. </summary>
        public ContainerServiceFleetUpdateStatus Status { get; }
        /// <summary> The stages composing an update run. Stages are run sequentially withing an UpdateRun. </summary>
        public IReadOnlyList<ContainerServiceFleetUpdateStageStatus> Stages { get; }
        /// <summary> The node image upgrade specs for the update run. It is only set in update run when `NodeImageSelection.type` is `Consistent`. </summary>
        internal NodeImageSelectionStatus NodeImageSelection { get; }
        /// <summary> The image versions to upgrade the nodes to. </summary>
        public IReadOnlyList<NodeImageVersion> SelectedNodeImageVersions
        {
            get => NodeImageSelection?.SelectedNodeImageVersions;
        }
    }
}
