// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The provisioning state of the UpdateRun resource. </summary>
    public readonly partial struct ContainerServiceFleetUpdateRunProvisioningState : IEquatable<ContainerServiceFleetUpdateRunProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateRunProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceFleetUpdateRunProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Resource has been created. </summary>
        public static ContainerServiceFleetUpdateRunProvisioningState Succeeded { get; } = new ContainerServiceFleetUpdateRunProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static ContainerServiceFleetUpdateRunProvisioningState Failed { get; } = new ContainerServiceFleetUpdateRunProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static ContainerServiceFleetUpdateRunProvisioningState Canceled { get; } = new ContainerServiceFleetUpdateRunProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="ContainerServiceFleetUpdateRunProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceFleetUpdateRunProvisioningState left, ContainerServiceFleetUpdateRunProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceFleetUpdateRunProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceFleetUpdateRunProvisioningState left, ContainerServiceFleetUpdateRunProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceFleetUpdateRunProvisioningState"/>. </summary>
        public static implicit operator ContainerServiceFleetUpdateRunProvisioningState(string value) => new ContainerServiceFleetUpdateRunProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceFleetUpdateRunProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceFleetUpdateRunProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
