// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The target type of a skip request. </summary>
    public readonly partial struct ContainerServiceFleetTargetType : IEquatable<ContainerServiceFleetTargetType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetTargetType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceFleetTargetType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MemberValue = "Member";
        private const string GroupValue = "Group";
        private const string StageValue = "Stage";
        private const string AfterStageWaitValue = "AfterStageWait";

        /// <summary> Skip the update of a member. </summary>
        public static ContainerServiceFleetTargetType Member { get; } = new ContainerServiceFleetTargetType(MemberValue);
        /// <summary> Skip the update of a group. </summary>
        public static ContainerServiceFleetTargetType Group { get; } = new ContainerServiceFleetTargetType(GroupValue);
        /// <summary> Skip the update of an entire stage including the after stage wait. </summary>
        public static ContainerServiceFleetTargetType Stage { get; } = new ContainerServiceFleetTargetType(StageValue);
        /// <summary> Skip the update of the after stage wait of a certain stage. </summary>
        public static ContainerServiceFleetTargetType AfterStageWait { get; } = new ContainerServiceFleetTargetType(AfterStageWaitValue);
        /// <summary> Determines if two <see cref="ContainerServiceFleetTargetType"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceFleetTargetType left, ContainerServiceFleetTargetType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceFleetTargetType"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceFleetTargetType left, ContainerServiceFleetTargetType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceFleetTargetType"/>. </summary>
        public static implicit operator ContainerServiceFleetTargetType(string value) => new ContainerServiceFleetTargetType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceFleetTargetType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceFleetTargetType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
