// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The type of upgrade to perform when targeting ManagedClusters. </summary>
    public readonly partial struct ContainerServiceFleetManagedClusterUpgradeType : IEquatable<ContainerServiceFleetManagedClusterUpgradeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetManagedClusterUpgradeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceFleetManagedClusterUpgradeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FullValue = "Full";
        private const string NodeImageOnlyValue = "NodeImageOnly";
        private const string ControlPlaneOnlyValue = "ControlPlaneOnly";

        /// <summary> Full upgrades the control plane and all agent pools of the target ManagedClusters. Requires the ManagedClusterUpgradeSpec.KubernetesVersion property to be set. </summary>
        public static ContainerServiceFleetManagedClusterUpgradeType Full { get; } = new ContainerServiceFleetManagedClusterUpgradeType(FullValue);
        /// <summary> NodeImageOnly upgrades only the node images of the target ManagedClusters. Requires the ManagedClusterUpgradeSpec.KubernetesVersion property to NOT be set. </summary>
        public static ContainerServiceFleetManagedClusterUpgradeType NodeImageOnly { get; } = new ContainerServiceFleetManagedClusterUpgradeType(NodeImageOnlyValue);
        /// <summary> ControlPlaneOnly upgrades only targets the KubernetesVersion of the ManagedClusters and will not be applied to the AgentPool. Requires the ManagedClusterUpgradeSpec.KubernetesVersion property to be set. </summary>
        public static ContainerServiceFleetManagedClusterUpgradeType ControlPlaneOnly { get; } = new ContainerServiceFleetManagedClusterUpgradeType(ControlPlaneOnlyValue);
        /// <summary> Determines if two <see cref="ContainerServiceFleetManagedClusterUpgradeType"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceFleetManagedClusterUpgradeType left, ContainerServiceFleetManagedClusterUpgradeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceFleetManagedClusterUpgradeType"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceFleetManagedClusterUpgradeType left, ContainerServiceFleetManagedClusterUpgradeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceFleetManagedClusterUpgradeType"/>. </summary>
        public static implicit operator ContainerServiceFleetManagedClusterUpgradeType(string value) => new ContainerServiceFleetManagedClusterUpgradeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceFleetManagedClusterUpgradeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceFleetManagedClusterUpgradeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
