// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The update to be applied to the ManagedClusters. </summary>
    public partial class ContainerServiceFleetManagedClusterUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetManagedClusterUpdate"/>. </summary>
        /// <param name="upgrade"> The upgrade to apply to the ManagedClusters. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="upgrade"/> is null. </exception>
        public ContainerServiceFleetManagedClusterUpdate(ContainerServiceFleetManagedClusterUpgradeSpec upgrade)
        {
            Argument.AssertNotNull(upgrade, nameof(upgrade));

            Upgrade = upgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetManagedClusterUpdate"/>. </summary>
        /// <param name="upgrade"> The upgrade to apply to the ManagedClusters. </param>
        /// <param name="nodeImageSelection"> The node image upgrade to be applied to the target nodes in update run. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceFleetManagedClusterUpdate(ContainerServiceFleetManagedClusterUpgradeSpec upgrade, NodeImageSelection nodeImageSelection, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Upgrade = upgrade;
            NodeImageSelection = nodeImageSelection;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetManagedClusterUpdate"/> for deserialization. </summary>
        internal ContainerServiceFleetManagedClusterUpdate()
        {
        }

        /// <summary> The upgrade to apply to the ManagedClusters. </summary>
        public ContainerServiceFleetManagedClusterUpgradeSpec Upgrade { get; set; }
        /// <summary> The node image upgrade to be applied to the target nodes in update run. </summary>
        public NodeImageSelection NodeImageSelection { get; set; }
    }
}
