// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The provisioning state of the AutoUpgradeProfile resource. </summary>
    public readonly partial struct AutoUpgradeProfileProvisioningState : IEquatable<AutoUpgradeProfileProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeProfileProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutoUpgradeProfileProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Resource has been created. </summary>
        public static AutoUpgradeProfileProvisioningState Succeeded { get; } = new AutoUpgradeProfileProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static AutoUpgradeProfileProvisioningState Failed { get; } = new AutoUpgradeProfileProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static AutoUpgradeProfileProvisioningState Canceled { get; } = new AutoUpgradeProfileProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="AutoUpgradeProfileProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AutoUpgradeProfileProvisioningState left, AutoUpgradeProfileProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutoUpgradeProfileProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AutoUpgradeProfileProvisioningState left, AutoUpgradeProfileProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutoUpgradeProfileProvisioningState"/>. </summary>
        public static implicit operator AutoUpgradeProfileProvisioningState(string value) => new AutoUpgradeProfileProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutoUpgradeProfileProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutoUpgradeProfileProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
