// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerServiceFleet.Models
{
    /// <summary> The node image upgrade to be applied to the target clusters in auto upgrade. </summary>
    internal partial class AutoUpgradeNodeImageSelection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeNodeImageSelection"/>. </summary>
        /// <param name="selectionType"> The node image upgrade type. </param>
        public AutoUpgradeNodeImageSelection(AutoUpgradeNodeImageSelectionType selectionType)
        {
            SelectionType = selectionType;
        }

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeNodeImageSelection"/>. </summary>
        /// <param name="selectionType"> The node image upgrade type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoUpgradeNodeImageSelection(AutoUpgradeNodeImageSelectionType selectionType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SelectionType = selectionType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeNodeImageSelection"/> for deserialization. </summary>
        internal AutoUpgradeNodeImageSelection()
        {
        }

        /// <summary> The node image upgrade type. </summary>
        public AutoUpgradeNodeImageSelectionType SelectionType { get; set; }
    }
}
