// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerServiceFleet
{
    internal class FleetUpdateStrategyOperationSource : IOperationSource<FleetUpdateStrategyResource>
    {
        private readonly ArmClient _client;

        internal FleetUpdateStrategyOperationSource(ArmClient client)
        {
            _client = client;
        }

        FleetUpdateStrategyResource IOperationSource<FleetUpdateStrategyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FleetUpdateStrategyData.DeserializeFleetUpdateStrategyData(document.RootElement);
            return new FleetUpdateStrategyResource(_client, data);
        }

        async ValueTask<FleetUpdateStrategyResource> IOperationSource<FleetUpdateStrategyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FleetUpdateStrategyData.DeserializeFleetUpdateStrategyData(document.RootElement);
            return new FleetUpdateStrategyResource(_client, data);
        }
    }
}
