// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerServiceFleet
{
    internal class ContainerServiceFleetUpdateRunOperationSource : IOperationSource<ContainerServiceFleetUpdateRunResource>
    {
        private readonly ArmClient _client;

        internal ContainerServiceFleetUpdateRunOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerServiceFleetUpdateRunResource IOperationSource<ContainerServiceFleetUpdateRunResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerServiceFleetUpdateRunData.DeserializeContainerServiceFleetUpdateRunData(document.RootElement);
            return new ContainerServiceFleetUpdateRunResource(_client, data);
        }

        async ValueTask<ContainerServiceFleetUpdateRunResource> IOperationSource<ContainerServiceFleetUpdateRunResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerServiceFleetUpdateRunData.DeserializeContainerServiceFleetUpdateRunData(document.RootElement);
            return new ContainerServiceFleetUpdateRunResource(_client, data);
        }
    }
}
