// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerServiceFleet
{
    internal class ContainerServiceFleetOperationSource : IOperationSource<ContainerServiceFleetResource>
    {
        private readonly ArmClient _client;

        internal ContainerServiceFleetOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerServiceFleetResource IOperationSource<ContainerServiceFleetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerServiceFleetData.DeserializeContainerServiceFleetData(document.RootElement);
            return new ContainerServiceFleetResource(_client, data);
        }

        async ValueTask<ContainerServiceFleetResource> IOperationSource<ContainerServiceFleetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerServiceFleetData.DeserializeContainerServiceFleetData(document.RootElement);
            return new ContainerServiceFleetResource(_client, data);
        }
    }
}
