// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerServiceFleet
{
    internal class AutoUpgradeProfileOperationSource : IOperationSource<AutoUpgradeProfileResource>
    {
        private readonly ArmClient _client;

        internal AutoUpgradeProfileOperationSource(ArmClient client)
        {
            _client = client;
        }

        AutoUpgradeProfileResource IOperationSource<AutoUpgradeProfileResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AutoUpgradeProfileData.DeserializeAutoUpgradeProfileData(document.RootElement);
            return new AutoUpgradeProfileResource(_client, data);
        }

        async ValueTask<AutoUpgradeProfileResource> IOperationSource<AutoUpgradeProfileResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AutoUpgradeProfileData.DeserializeAutoUpgradeProfileData(document.RootElement);
            return new AutoUpgradeProfileResource(_client, data);
        }
    }
}
