// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ContainerServiceFleet.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableContainerServiceFleetArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableContainerServiceFleetArmClient"/> class for mocking. </summary>
        protected MockableContainerServiceFleetArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableContainerServiceFleetArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableContainerServiceFleetArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableContainerServiceFleetArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerServiceFleetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerServiceFleetResource.CreateResourceIdentifier" /> to create a <see cref="ContainerServiceFleetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerServiceFleetResource"/> object. </returns>
        public virtual ContainerServiceFleetResource GetContainerServiceFleetResource(ResourceIdentifier id)
        {
            ContainerServiceFleetResource.ValidateResourceId(id);
            return new ContainerServiceFleetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutoUpgradeProfileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutoUpgradeProfileResource.CreateResourceIdentifier" /> to create an <see cref="AutoUpgradeProfileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutoUpgradeProfileResource"/> object. </returns>
        public virtual AutoUpgradeProfileResource GetAutoUpgradeProfileResource(ResourceIdentifier id)
        {
            AutoUpgradeProfileResource.ValidateResourceId(id);
            return new AutoUpgradeProfileResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerServiceFleetMemberResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerServiceFleetMemberResource.CreateResourceIdentifier" /> to create a <see cref="ContainerServiceFleetMemberResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerServiceFleetMemberResource"/> object. </returns>
        public virtual ContainerServiceFleetMemberResource GetContainerServiceFleetMemberResource(ResourceIdentifier id)
        {
            ContainerServiceFleetMemberResource.ValidateResourceId(id);
            return new ContainerServiceFleetMemberResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContainerServiceFleetUpdateRunResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContainerServiceFleetUpdateRunResource.CreateResourceIdentifier" /> to create a <see cref="ContainerServiceFleetUpdateRunResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContainerServiceFleetUpdateRunResource"/> object. </returns>
        public virtual ContainerServiceFleetUpdateRunResource GetContainerServiceFleetUpdateRunResource(ResourceIdentifier id)
        {
            ContainerServiceFleetUpdateRunResource.ValidateResourceId(id);
            return new ContainerServiceFleetUpdateRunResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FleetUpdateStrategyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FleetUpdateStrategyResource.CreateResourceIdentifier" /> to create a <see cref="FleetUpdateStrategyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FleetUpdateStrategyResource"/> object. </returns>
        public virtual FleetUpdateStrategyResource GetFleetUpdateStrategyResource(ResourceIdentifier id)
        {
            FleetUpdateStrategyResource.ValidateResourceId(id);
            return new FleetUpdateStrategyResource(Client, id);
        }
    }
}
