// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ContainerServiceFleet.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerServiceFleet
{
    /// <summary>
    /// A class representing the ContainerServiceFleetUpdateRun data model.
    /// A multi-stage process to perform update operations across members of a Fleet.
    /// </summary>
    public partial class ContainerServiceFleetUpdateRunData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateRunData"/>. </summary>
        public ContainerServiceFleetUpdateRunData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceFleetUpdateRunData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="eTag"> If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields. </param>
        /// <param name="provisioningState"> The provisioning state of the UpdateRun resource. </param>
        /// <param name="updateStrategyId">
        /// The resource id of the FleetUpdateStrategy resource to reference.
        ///
        /// When creating a new run, there are three ways to define a strategy for the run:
        /// 1. Define a new strategy in place: Set the "strategy" field.
        /// 2. Use an existing strategy: Set the "updateStrategyId" field. (since 2023-08-15-preview)
        /// 3. Use the default strategy to update all the members one by one: Leave both "updateStrategyId" and "strategy" unset. (since 2023-08-15-preview)
        ///
        /// Setting both "updateStrategyId" and "strategy" is invalid.
        ///
        /// UpdateRuns created by "updateStrategyId" snapshot the referenced UpdateStrategy at the time of creation and store it in the "strategy" field.
        /// Subsequent changes to the referenced FleetUpdateStrategy resource do not propagate.
        /// UpdateRunStrategy changes can be made directly on the "strategy" field before launching the UpdateRun.
        /// </param>
        /// <param name="strategy">
        /// The strategy defines the order in which the clusters will be updated.
        /// If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
        /// The strategy of the UpdateRun can be modified until the run is started.
        /// </param>
        /// <param name="managedClusterUpdate"> The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started. </param>
        /// <param name="status"> The status of the UpdateRun. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceFleetUpdateRunData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ETag? eTag, ContainerServiceFleetUpdateRunProvisioningState? provisioningState, ResourceIdentifier updateStrategyId, ContainerServiceFleetUpdateRunStrategy strategy, ContainerServiceFleetManagedClusterUpdate managedClusterUpdate, ContainerServiceFleetUpdateRunStatus status, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ETag = eTag;
            ProvisioningState = provisioningState;
            UpdateStrategyId = updateStrategyId;
            Strategy = strategy;
            ManagedClusterUpdate = managedClusterUpdate;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields. </summary>
        public ETag? ETag { get; }
        /// <summary> The provisioning state of the UpdateRun resource. </summary>
        public ContainerServiceFleetUpdateRunProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The resource id of the FleetUpdateStrategy resource to reference.
        ///
        /// When creating a new run, there are three ways to define a strategy for the run:
        /// 1. Define a new strategy in place: Set the "strategy" field.
        /// 2. Use an existing strategy: Set the "updateStrategyId" field. (since 2023-08-15-preview)
        /// 3. Use the default strategy to update all the members one by one: Leave both "updateStrategyId" and "strategy" unset. (since 2023-08-15-preview)
        ///
        /// Setting both "updateStrategyId" and "strategy" is invalid.
        ///
        /// UpdateRuns created by "updateStrategyId" snapshot the referenced UpdateStrategy at the time of creation and store it in the "strategy" field.
        /// Subsequent changes to the referenced FleetUpdateStrategy resource do not propagate.
        /// UpdateRunStrategy changes can be made directly on the "strategy" field before launching the UpdateRun.
        /// </summary>
        public ResourceIdentifier UpdateStrategyId { get; set; }
        /// <summary>
        /// The strategy defines the order in which the clusters will be updated.
        /// If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
        /// The strategy of the UpdateRun can be modified until the run is started.
        /// </summary>
        internal ContainerServiceFleetUpdateRunStrategy Strategy { get; set; }
        /// <summary> The list of stages that compose this update run. Min size: 1. </summary>
        public IList<ContainerServiceFleetUpdateStage> StrategyStages
        {
            get => Strategy is null ? default : Strategy.Stages;
            set => Strategy = new ContainerServiceFleetUpdateRunStrategy(value);
        }

        /// <summary> The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started. </summary>
        public ContainerServiceFleetManagedClusterUpdate ManagedClusterUpdate { get; set; }
        /// <summary> The status of the UpdateRun. </summary>
        public ContainerServiceFleetUpdateRunStatus Status { get; }
    }
}
