// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ContainerServiceFleet
{
    /// <summary>
    /// A class representing a collection of <see cref="AutoUpgradeProfileResource"/> and their operations.
    /// Each <see cref="AutoUpgradeProfileResource"/> in the collection will belong to the same instance of <see cref="ContainerServiceFleetResource"/>.
    /// To get an <see cref="AutoUpgradeProfileCollection"/> instance call the GetAutoUpgradeProfiles method from an instance of <see cref="ContainerServiceFleetResource"/>.
    /// </summary>
    public partial class AutoUpgradeProfileCollection : ArmCollection, IEnumerable<AutoUpgradeProfileResource>, IAsyncEnumerable<AutoUpgradeProfileResource>
    {
        private readonly ClientDiagnostics _autoUpgradeProfileClientDiagnostics;
        private readonly AutoUpgradeProfilesRestOperations _autoUpgradeProfileRestClient;

        /// <summary> Initializes a new instance of the <see cref="AutoUpgradeProfileCollection"/> class for mocking. </summary>
        protected AutoUpgradeProfileCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AutoUpgradeProfileCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AutoUpgradeProfileCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _autoUpgradeProfileClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ContainerServiceFleet", AutoUpgradeProfileResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AutoUpgradeProfileResource.ResourceType, out string autoUpgradeProfileApiVersion);
            _autoUpgradeProfileRestClient = new AutoUpgradeProfilesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, autoUpgradeProfileApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ContainerServiceFleetResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ContainerServiceFleetResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a AutoUpgradeProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="ifMatch"> The request should only proceed if an entity matches this string. </param>
        /// <param name="ifNoneMatch"> The request should only proceed if no entity matches this string. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AutoUpgradeProfileResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string autoUpgradeProfileName, AutoUpgradeProfileData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _autoUpgradeProfileRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, data, ifMatch, ifNoneMatch, cancellationToken).ConfigureAwait(false);
                var operation = new ContainerServiceFleetArmOperation<AutoUpgradeProfileResource>(new AutoUpgradeProfileOperationSource(Client), _autoUpgradeProfileClientDiagnostics, Pipeline, _autoUpgradeProfileRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, data, ifMatch, ifNoneMatch).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a AutoUpgradeProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="ifMatch"> The request should only proceed if an entity matches this string. </param>
        /// <param name="ifNoneMatch"> The request should only proceed if no entity matches this string. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AutoUpgradeProfileResource> CreateOrUpdate(WaitUntil waitUntil, string autoUpgradeProfileName, AutoUpgradeProfileData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _autoUpgradeProfileRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, data, ifMatch, ifNoneMatch, cancellationToken);
                var operation = new ContainerServiceFleetArmOperation<AutoUpgradeProfileResource>(new AutoUpgradeProfileOperationSource(Client), _autoUpgradeProfileClientDiagnostics, Pipeline, _autoUpgradeProfileRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, data, ifMatch, ifNoneMatch).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AutoUpgradeProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> is null. </exception>
        public virtual async Task<Response<AutoUpgradeProfileResource>> GetAsync(string autoUpgradeProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.Get");
            scope.Start();
            try
            {
                var response = await _autoUpgradeProfileRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutoUpgradeProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AutoUpgradeProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> is null. </exception>
        public virtual Response<AutoUpgradeProfileResource> Get(string autoUpgradeProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.Get");
            scope.Start();
            try
            {
                var response = _autoUpgradeProfileRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutoUpgradeProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List AutoUpgradeProfile resources by Fleet
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_ListByFleet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AutoUpgradeProfileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AutoUpgradeProfileResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _autoUpgradeProfileRestClient.CreateListByFleetRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _autoUpgradeProfileRestClient.CreateListByFleetNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AutoUpgradeProfileResource(Client, AutoUpgradeProfileData.DeserializeAutoUpgradeProfileData(e)), _autoUpgradeProfileClientDiagnostics, Pipeline, "AutoUpgradeProfileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List AutoUpgradeProfile resources by Fleet
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_ListByFleet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AutoUpgradeProfileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AutoUpgradeProfileResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _autoUpgradeProfileRestClient.CreateListByFleetRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _autoUpgradeProfileRestClient.CreateListByFleetNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AutoUpgradeProfileResource(Client, AutoUpgradeProfileData.DeserializeAutoUpgradeProfileData(e)), _autoUpgradeProfileClientDiagnostics, Pipeline, "AutoUpgradeProfileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string autoUpgradeProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.Exists");
            scope.Start();
            try
            {
                var response = await _autoUpgradeProfileRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> is null. </exception>
        public virtual Response<bool> Exists(string autoUpgradeProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.Exists");
            scope.Start();
            try
            {
                var response = _autoUpgradeProfileRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> is null. </exception>
        public virtual async Task<NullableResponse<AutoUpgradeProfileResource>> GetIfExistsAsync(string autoUpgradeProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _autoUpgradeProfileRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AutoUpgradeProfileResource>(response.GetRawResponse());
                return Response.FromValue(new AutoUpgradeProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutoUpgradeProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-02-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutoUpgradeProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autoUpgradeProfileName"> The name of the AutoUpgradeProfile resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autoUpgradeProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autoUpgradeProfileName"/> is null. </exception>
        public virtual NullableResponse<AutoUpgradeProfileResource> GetIfExists(string autoUpgradeProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autoUpgradeProfileName, nameof(autoUpgradeProfileName));

            using var scope = _autoUpgradeProfileClientDiagnostics.CreateScope("AutoUpgradeProfileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _autoUpgradeProfileRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, autoUpgradeProfileName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AutoUpgradeProfileResource>(response.GetRawResponse());
                return Response.FromValue(new AutoUpgradeProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AutoUpgradeProfileResource> IEnumerable<AutoUpgradeProfileResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AutoUpgradeProfileResource> IAsyncEnumerable<AutoUpgradeProfileResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
