// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.Vision.Face.Samples
{
    public partial class Samples_LargePersonGroupClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_Create_CreateLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_name",
                userData = "your_user_data",
                recognitionModel = "recognition_01",
            });
            Response response = client.Create(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_Create_CreateLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_name",
                userData = "your_user_data",
                recognitionModel = "recognition_01",
            });
            Response response = await client.CreateAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_Create_CreateLargePersonGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.Create("your_large_person_group_name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_Create_CreateLargePersonGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.CreateAsync("your_large_person_group_name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_Delete_DeleteLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.Delete();

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_Delete_DeleteLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.DeleteAsync();

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_GetLargePersonGroup_GetLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.GetLargePersonGroup(true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("largePersonGroupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_GetLargePersonGroup_GetLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.GetLargePersonGroupAsync(true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("largePersonGroupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_GetLargePersonGroup_GetLargePersonGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<LargePersonGroup> response = client.GetLargePersonGroup();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_GetLargePersonGroup_GetLargePersonGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<LargePersonGroup> response = await client.GetLargePersonGroupAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_Update_UpdateLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_name",
                userData = "your_user_data",
            });
            Response response = client.Update(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_Update_UpdateLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_name",
                userData = "your_user_data",
            });
            Response response = await client.UpdateAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_GetLargePersonGroups_GetLargePersonGroups()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient(null);

            Response response = client.GetLargePersonGroups("00000000-0000-0000-0000-000000000000", 20, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("largePersonGroupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_GetLargePersonGroups_GetLargePersonGroups_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient(null);

            Response response = await client.GetLargePersonGroupsAsync("00000000-0000-0000-0000-000000000000", 20, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("largePersonGroupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_GetLargePersonGroups_GetLargePersonGroups_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient(null);

            Response<IReadOnlyList<LargePersonGroup>> response = client.GetLargePersonGroups();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_GetLargePersonGroups_GetLargePersonGroups_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient(null);

            Response<IReadOnlyList<LargePersonGroup>> response = await client.GetLargePersonGroupsAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_GetTrainingStatus_GetTrainingStatusOfLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.GetTrainingStatus(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastSuccessfulTrainingDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_GetTrainingStatus_GetTrainingStatusOfLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.GetTrainingStatusAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastSuccessfulTrainingDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_GetTrainingStatus_GetTrainingStatusOfLargePersonGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<FaceTrainingResult> response = client.GetTrainingStatus();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_GetTrainingStatus_GetTrainingStatusOfLargePersonGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<FaceTrainingResult> response = await client.GetTrainingStatusAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_CreatePerson_CreatePersonInLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_person_name",
                userData = "your_user_data",
            });
            Response response = client.CreatePerson(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("personId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_CreatePerson_CreatePersonInLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_person_name",
                userData = "your_user_data",
            });
            Response response = await client.CreatePersonAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("personId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_CreatePerson_CreatePersonInLargePersonGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<CreatePersonResult> response = client.CreatePerson("your_large_person_group_person_name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_CreatePerson_CreatePersonInLargePersonGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<CreatePersonResult> response = await client.CreatePersonAsync("your_large_person_group_person_name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_DeletePerson_DeletePersonFromLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.DeletePerson(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_DeletePerson_DeletePersonFromLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.DeletePersonAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_GetPerson_GetPersonFromLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.GetPerson(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("personId").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_GetPerson_GetPersonFromLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.GetPersonAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("personId").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_GetPerson_GetPersonFromLargePersonGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<LargePersonGroupPerson> response = client.GetPerson(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_GetPerson_GetPersonFromLargePersonGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<LargePersonGroupPerson> response = await client.GetPersonAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_UpdatePerson_UpdatePersonInLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_person_name",
                userData = "your_user_data",
            });
            Response response = client.UpdatePerson(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_UpdatePerson_UpdatePersonInLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_person_group_person_name",
                userData = "your_user_data",
            });
            Response response = await client.UpdatePersonAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_GetPersons_GetPersonsFromLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.GetPersons("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("personId").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_GetPersons_GetPersonsFromLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.GetPersonsAsync("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("personId").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPerson_GetPersons_GetPersonsFromLargePersonGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<IReadOnlyList<LargePersonGroupPerson>> response = client.GetPersons();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPerson_GetPersons_GetPersonsFromLargePersonGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<IReadOnlyList<LargePersonGroupPerson>> response = await client.GetPersonsAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPersonFace_DeleteFace_DeleteFaceFromLargePersonGroupPerson()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.DeleteFace(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPersonFace_DeleteFace_DeleteFaceFromLargePersonGroupPerson_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.DeleteFaceAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPersonFace_GetFace_GetFaceFromLargePersonGroupPerson()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = client.GetFace(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("persistedFaceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPersonFace_GetFace_GetFaceFromLargePersonGroupPerson_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response response = await client.GetFaceAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("persistedFaceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPersonFace_GetFace_GetFaceFromLargePersonGroupPerson_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<LargePersonGroupPersonFace> response = client.GetFace(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPersonFace_GetFace_GetFaceFromLargePersonGroupPerson_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Response<LargePersonGroupPersonFace> response = await client.GetFaceAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroupPersonFace_UpdateFace_UpdateFaceInLargePersonGroupPerson()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                userData = "your_user_data",
            });
            Response response = client.UpdateFace(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroupPersonFace_UpdateFace_UpdateFaceInLargePersonGroupPerson_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            using RequestContent content = RequestContent.Create(new
            {
                userData = "your_user_data",
            });
            Response response = await client.UpdateFaceAsync(Guid.Parse("25985303-c537-4467-b41d-bdb45cd95ca1"), Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargePersonGroup_Train_TrainLargePersonGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Operation operation = client.Train(WaitUntil.Completed);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargePersonGroup_Train_TrainLargePersonGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargePersonGroupClient client = new FaceAdministrationClient(endpoint, credential).GetLargePersonGroupClient("your_large_person_group_id");

            Operation operation = await client.TrainAsync(WaitUntil.Completed);
        }
    }
}
