// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.Vision.Face.Samples
{
    public partial class Samples_LargeFaceListClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_Create_CreateLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_face_list_name",
                userData = "your_user_data",
                recognitionModel = "recognition_01",
            });
            Response response = client.Create(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_Create_CreateLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_face_list_name",
                userData = "your_user_data",
                recognitionModel = "recognition_01",
            });
            Response response = await client.CreateAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_Create_CreateLargeFaceList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.Create("your_large_face_list_name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_Create_CreateLargeFaceList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.CreateAsync("your_large_face_list_name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_Delete_DeleteLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.Delete();

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_Delete_DeleteLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.DeleteAsync();

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_GetLargeFaceList_GetLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.GetLargeFaceList(true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("largeFaceListId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_GetLargeFaceList_GetLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.GetLargeFaceListAsync(true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("largeFaceListId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_GetLargeFaceList_GetLargeFaceList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<LargeFaceList> response = client.GetLargeFaceList();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_GetLargeFaceList_GetLargeFaceList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<LargeFaceList> response = await client.GetLargeFaceListAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_Update_UpdateLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_face_list_name",
                userData = "your_user_data",
            });
            Response response = client.Update(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_Update_UpdateLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            using RequestContent content = RequestContent.Create(new
            {
                name = "your_large_face_list_name",
                userData = "your_user_data",
            });
            Response response = await client.UpdateAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_GetLargeFaceLists_GetLargeFaceLists()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient(null);

            Response response = client.GetLargeFaceLists("my_list_id", 20, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("largeFaceListId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_GetLargeFaceLists_GetLargeFaceLists_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient(null);

            Response response = await client.GetLargeFaceListsAsync("my_list_id", 20, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("largeFaceListId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_GetLargeFaceLists_GetLargeFaceLists_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient(null);

            Response<IReadOnlyList<LargeFaceList>> response = client.GetLargeFaceLists();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_GetLargeFaceLists_GetLargeFaceLists_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient(null);

            Response<IReadOnlyList<LargeFaceList>> response = await client.GetLargeFaceListsAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_GetTrainingStatus_GetTrainingStatusOfLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.GetTrainingStatus(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastSuccessfulTrainingDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_GetTrainingStatus_GetTrainingStatusOfLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.GetTrainingStatusAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastSuccessfulTrainingDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_GetTrainingStatus_GetTrainingStatusOfLargeFaceList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<FaceTrainingResult> response = client.GetTrainingStatus();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_GetTrainingStatus_GetTrainingStatusOfLargeFaceList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<FaceTrainingResult> response = await client.GetTrainingStatusAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceListFace_DeleteFace_DeleteFaceFromLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.DeleteFace(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceListFace_DeleteFace_DeleteFaceFromLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.DeleteFaceAsync(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceListFace_GetFace_GetFaceFromLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.GetFace(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("persistedFaceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceListFace_GetFace_GetFaceFromLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.GetFaceAsync(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("persistedFaceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceListFace_GetFace_GetFaceFromLargeFaceList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<LargeFaceListFace> response = client.GetFace(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceListFace_GetFace_GetFaceFromLargeFaceList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<LargeFaceListFace> response = await client.GetFaceAsync(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceListFace_UpdateFace_UpdateFaceInLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            using RequestContent content = RequestContent.Create(new
            {
                userData = "your_user_data",
            });
            Response response = client.UpdateFace(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceListFace_UpdateFace_UpdateFaceInLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            using RequestContent content = RequestContent.Create(new
            {
                userData = "your_user_data",
            });
            Response response = await client.UpdateFaceAsync(Guid.Parse("43897a75-8d6f-42cf-885e-74832febb055"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceListFace_GetFaces_GetFacesFromLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = client.GetFaces("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("persistedFaceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceListFace_GetFaces_GetFacesFromLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response response = await client.GetFacesAsync("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("persistedFaceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceListFace_GetFaces_GetFacesFromLargeFaceList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<IReadOnlyList<LargeFaceListFace>> response = client.GetFaces();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceListFace_GetFaces_GetFacesFromLargeFaceList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Response<IReadOnlyList<LargeFaceListFace>> response = await client.GetFacesAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LargeFaceList_Train_TrainLargeFaceList()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Operation operation = client.Train(WaitUntil.Completed);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LargeFaceList_Train_TrainLargeFaceList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            LargeFaceListClient client = new FaceAdministrationClient(endpoint, credential).GetLargeFaceListClient("your_large_face_list_id");

            Operation operation = await client.TrainAsync(WaitUntil.Completed);
        }
    }
}
