// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.Vision.Face.Samples
{
    public partial class Samples_FaceSessionClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_CreateLivenessSession_CreateLivenessSession()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                livenessOperationMode = "Passive",
                sendResultsToClient = true,
                deviceCorrelationIdSetInClient = true,
                deviceCorrelationId = "your_device_correlation_id",
                authTokenTimeToLiveInSeconds = 60,
            });
            Response response = client.CreateLivenessSession(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("sessionId").ToString());
            Console.WriteLine(result.GetProperty("authToken").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_CreateLivenessSession_CreateLivenessSession_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                livenessOperationMode = "Passive",
                sendResultsToClient = true,
                deviceCorrelationIdSetInClient = true,
                deviceCorrelationId = "your_device_correlation_id",
                authTokenTimeToLiveInSeconds = 60,
            });
            Response response = await client.CreateLivenessSessionAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("sessionId").ToString());
            Console.WriteLine(result.GetProperty("authToken").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_CreateLivenessSession_CreateLivenessSession_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            CreateLivenessSessionContent body = new CreateLivenessSessionContent(LivenessOperationMode.Passive)
            {
                SendResultsToClient = true,
                DeviceCorrelationIdSetInClient = true,
                DeviceCorrelationId = "your_device_correlation_id",
                AuthTokenTimeToLiveInSeconds = 60,
            };
            Response<CreateLivenessSessionResult> response = client.CreateLivenessSession(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_CreateLivenessSession_CreateLivenessSession_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            CreateLivenessSessionContent body = new CreateLivenessSessionContent(LivenessOperationMode.Passive)
            {
                SendResultsToClient = true,
                DeviceCorrelationIdSetInClient = true,
                DeviceCorrelationId = "your_device_correlation_id",
                AuthTokenTimeToLiveInSeconds = 60,
            };
            Response<CreateLivenessSessionResult> response = await client.CreateLivenessSessionAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_DeleteLivenessSession_DeleteLivenessSession()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.DeleteLivenessSession("b12e033e-bda7-4b83-a211-e721c661f30e");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_DeleteLivenessSession_DeleteLivenessSession_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.DeleteLivenessSessionAsync("b12e033e-bda7-4b83-a211-e721c661f30e");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_GetLivenessSessionResult_GetLivenessSessionResult()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetLivenessSessionResult("b12e033e-bda7-4b83-a211-e721c661f30e", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("sessionExpired").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_GetLivenessSessionResult_GetLivenessSessionResult_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetLivenessSessionResultAsync("b12e033e-bda7-4b83-a211-e721c661f30e", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("sessionExpired").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_GetLivenessSessionResult_GetLivenessSessionResult_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<LivenessSession> response = client.GetLivenessSessionResult("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_GetLivenessSessionResult_GetLivenessSessionResult_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<LivenessSession> response = await client.GetLivenessSessionResultAsync("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_GetLivenessSessions_GetLivenessSessions()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetLivenessSessions("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("createdDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("sessionExpired").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_GetLivenessSessions_GetLivenessSessions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetLivenessSessionsAsync("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("createdDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("sessionExpired").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessSession_GetLivenessSessions_GetLivenessSessions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionItem>> response = client.GetLivenessSessions();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessSession_GetLivenessSessions_GetLivenessSessions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionItem>> response = await client.GetLivenessSessionsAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_GetLivenessSessionAuditEntries_GetLivenessSessionAuditEntries()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetLivenessSessionAuditEntries("b12e033e-bda7-4b83-a211-e721c661f30e", "0", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("sessionId").ToString());
            Console.WriteLine(result[0].GetProperty("requestId").ToString());
            Console.WriteLine(result[0].GetProperty("clientRequestId").ToString());
            Console.WriteLine(result[0].GetProperty("receivedDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("method").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("contentType").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("body").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("statusCode").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("latencyInMilliseconds").ToString());
            Console.WriteLine(result[0].GetProperty("digest").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_GetLivenessSessionAuditEntries_GetLivenessSessionAuditEntries_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetLivenessSessionAuditEntriesAsync("b12e033e-bda7-4b83-a211-e721c661f30e", "0", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("sessionId").ToString());
            Console.WriteLine(result[0].GetProperty("requestId").ToString());
            Console.WriteLine(result[0].GetProperty("clientRequestId").ToString());
            Console.WriteLine(result[0].GetProperty("receivedDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("method").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("contentType").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("body").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("statusCode").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("latencyInMilliseconds").ToString());
            Console.WriteLine(result[0].GetProperty("digest").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_GetLivenessSessionAuditEntries_GetLivenessSessionAuditEntries_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionAuditEntry>> response = client.GetLivenessSessionAuditEntries("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_GetLivenessSessionAuditEntries_GetLivenessSessionAuditEntries_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionAuditEntry>> response = await client.GetLivenessSessionAuditEntriesAsync("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessWithVerifySession_DeleteLivenessWithVerifySession_DeleteLivenessWithVerifySession()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.DeleteLivenessWithVerifySession("b12e033e-bda7-4b83-a211-e721c661f30e");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessWithVerifySession_DeleteLivenessWithVerifySession_DeleteLivenessWithVerifySession_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.DeleteLivenessWithVerifySessionAsync("b12e033e-bda7-4b83-a211-e721c661f30e");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessWithVerifySession_GetLivenessWithVerifySessionResult_GetLivenessWithVerifySessionResult()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetLivenessWithVerifySessionResult("b12e033e-bda7-4b83-a211-e721c661f30e", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("sessionExpired").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessWithVerifySession_GetLivenessWithVerifySessionResult_GetLivenessWithVerifySessionResult_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetLivenessWithVerifySessionResultAsync("b12e033e-bda7-4b83-a211-e721c661f30e", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("sessionExpired").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessWithVerifySession_GetLivenessWithVerifySessionResult_GetLivenessWithVerifySessionResult_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<LivenessWithVerifySession> response = client.GetLivenessWithVerifySessionResult("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessWithVerifySession_GetLivenessWithVerifySessionResult_GetLivenessWithVerifySessionResult_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<LivenessWithVerifySession> response = await client.GetLivenessWithVerifySessionResultAsync("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessWithVerifySession_GetLivenessWithVerifySessions_GetLivenessWithVerifySessions()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetLivenessWithVerifySessions("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("createdDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("sessionExpired").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessWithVerifySession_GetLivenessWithVerifySessions_GetLivenessWithVerifySessions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetLivenessWithVerifySessionsAsync("00000000-0000-0000-0000-000000000000", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("createdDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("sessionExpired").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_LivenessWithVerifySession_GetLivenessWithVerifySessions_GetLivenessWithVerifySessions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionItem>> response = client.GetLivenessWithVerifySessions();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_LivenessWithVerifySession_GetLivenessWithVerifySessions_GetLivenessWithVerifySessions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionItem>> response = await client.GetLivenessWithVerifySessionsAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_GetLivenessWithVerifySessionAuditEntries_GetLivenessWithVerifySessionAuditEntries()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetLivenessWithVerifySessionAuditEntries("b12e033e-bda7-4b83-a211-e721c661f30e", "0", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("sessionId").ToString());
            Console.WriteLine(result[0].GetProperty("requestId").ToString());
            Console.WriteLine(result[0].GetProperty("clientRequestId").ToString());
            Console.WriteLine(result[0].GetProperty("receivedDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("method").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("contentType").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("body").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("statusCode").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("latencyInMilliseconds").ToString());
            Console.WriteLine(result[0].GetProperty("digest").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_GetLivenessWithVerifySessionAuditEntries_GetLivenessWithVerifySessionAuditEntries_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetLivenessWithVerifySessionAuditEntriesAsync("b12e033e-bda7-4b83-a211-e721c661f30e", "0", 20, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("sessionId").ToString());
            Console.WriteLine(result[0].GetProperty("requestId").ToString());
            Console.WriteLine(result[0].GetProperty("clientRequestId").ToString());
            Console.WriteLine(result[0].GetProperty("receivedDateTime").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("method").ToString());
            Console.WriteLine(result[0].GetProperty("request").GetProperty("contentType").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("body").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("statusCode").ToString());
            Console.WriteLine(result[0].GetProperty("response").GetProperty("latencyInMilliseconds").ToString());
            Console.WriteLine(result[0].GetProperty("digest").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_GetLivenessWithVerifySessionAuditEntries_GetLivenessWithVerifySessionAuditEntries_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionAuditEntry>> response = client.GetLivenessWithVerifySessionAuditEntries("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_GetLivenessWithVerifySessionAuditEntries_GetLivenessWithVerifySessionAuditEntries_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<LivenessSessionAuditEntry>> response = await client.GetLivenessWithVerifySessionAuditEntriesAsync("b12e033e-bda7-4b83-a211-e721c661f30e");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_DetectFromSessionImage_DetectFromSessionImageId()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                sessionImageId = "aa93ce80-9a9b-48bd-ae1a-1c7543841e92",
            });
            Response response = client.DetectFromSessionImage(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("top").ToString());
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("left").ToString());
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("width").ToString());
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("height").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_DetectFromSessionImage_DetectFromSessionImageId_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                sessionImageId = "aa93ce80-9a9b-48bd-ae1a-1c7543841e92",
            });
            Response response = await client.DetectFromSessionImageAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("top").ToString());
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("left").ToString());
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("width").ToString());
            Console.WriteLine(result[0].GetProperty("faceRectangle").GetProperty("height").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_DetectFromSessionImage_DetectFromSessionImageId_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<FaceDetectionResult>> response = client.DetectFromSessionImage("aa93ce80-9a9b-48bd-ae1a-1c7543841e92");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_DetectFromSessionImage_DetectFromSessionImageId_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<IReadOnlyList<FaceDetectionResult>> response = await client.DetectFromSessionImageAsync("aa93ce80-9a9b-48bd-ae1a-1c7543841e92");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_GetSessionImage_GetSessionImage()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = client.GetSessionImage("3d035d35-2e01-4ed4-8935-577afde9caaa", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_GetSessionImage_GetSessionImage_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response response = await client.GetSessionImageAsync("3d035d35-2e01-4ed4-8935-577afde9caaa", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_FaceSessionClient_GetSessionImage_GetSessionImage_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<BinaryData> response = client.GetSessionImage("3d035d35-2e01-4ed4-8935-577afde9caaa");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_FaceSessionClient_GetSessionImage_GetSessionImage_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            FaceSessionClient client = new FaceSessionClient(endpoint, credential);

            Response<BinaryData> response = await client.GetSessionImageAsync("3d035d35-2e01-4ed4-8935-577afde9caaa");
        }
    }
}
