// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Vision.Face
{
    /// <summary> Indicates quality of image for recognition. </summary>
    public readonly partial struct QualityForRecognition : IEquatable<QualityForRecognition>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QualityForRecognition"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QualityForRecognition(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "low";
        private const string MediumValue = "medium";
        private const string HighValue = "high";

        /// <summary> Low quality. </summary>
        public static QualityForRecognition Low { get; } = new QualityForRecognition(LowValue);
        /// <summary> Medium quality. </summary>
        public static QualityForRecognition Medium { get; } = new QualityForRecognition(MediumValue);
        /// <summary> High quality. </summary>
        public static QualityForRecognition High { get; } = new QualityForRecognition(HighValue);
        /// <summary> Determines if two <see cref="QualityForRecognition"/> values are the same. </summary>
        public static bool operator ==(QualityForRecognition left, QualityForRecognition right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QualityForRecognition"/> values are not the same. </summary>
        public static bool operator !=(QualityForRecognition left, QualityForRecognition right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QualityForRecognition"/>. </summary>
        public static implicit operator QualityForRecognition(string value) => new QualityForRecognition(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QualityForRecognition other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QualityForRecognition other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
