// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Vision.Face
{
    /// <summary> Indicates level of noise. </summary>
    public readonly partial struct NoiseLevel : IEquatable<NoiseLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NoiseLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NoiseLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "low";
        private const string MediumValue = "medium";
        private const string HighValue = "high";

        /// <summary> Low noise level. </summary>
        public static NoiseLevel Low { get; } = new NoiseLevel(LowValue);
        /// <summary> Medium noise level. </summary>
        public static NoiseLevel Medium { get; } = new NoiseLevel(MediumValue);
        /// <summary> High noise level. </summary>
        public static NoiseLevel High { get; } = new NoiseLevel(HighValue);
        /// <summary> Determines if two <see cref="NoiseLevel"/> values are the same. </summary>
        public static bool operator ==(NoiseLevel left, NoiseLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NoiseLevel"/> values are not the same. </summary>
        public static bool operator !=(NoiseLevel left, NoiseLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NoiseLevel"/>. </summary>
        public static implicit operator NoiseLevel(string value) => new NoiseLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NoiseLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NoiseLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
